/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TimedSet;
import com.newrelic.agent.TokenImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.RemovalCause;
import com.newrelic.agent.deps.com.google.common.cache.RemovalListener;
import com.newrelic.agent.deps.com.google.common.cache.RemovalNotification;
import com.newrelic.agent.util.TimeConversion;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class TimedTokenSet
implements TimedSet<TokenImpl> {
    private final AtomicInteger timedOutTokens = new AtomicInteger(0);
    private final Cache<TokenImpl, TokenImpl> activeTokens;

    public TimedTokenSet(int timeOut, TimeUnit unit) {
        long timeOutMilli = TimeConversion.convertToMilliWithLowerBound(timeOut, unit, 250L);
        this.activeTokens = CacheBuilder.newBuilder().concurrencyLevel(2).expireAfterAccess(timeOutMilli, TimeUnit.MILLISECONDS).removalListener(new RemovalListener<TokenImpl, TokenImpl>(){

            @Override
            public void onRemoval(RemovalNotification<TokenImpl, TokenImpl> notification) {
                RemovalCause cause = notification.getCause();
                TokenImpl token = notification.getKey();
                Transaction tx = token.getTransaction();
                if (cause == RemovalCause.EXPIRED) {
                    Agent.LOG.log(Level.FINEST, "Timing out token {0} on transaction {1}", new Object[]{token, tx});
                    TimedTokenSet.this.timedOutTokens.incrementAndGet();
                } else if (cause == RemovalCause.EXPLICIT) {
                    Agent.LOG.log(Level.FINEST, "Expiring token {0} on transaction {1}", new Object[]{token, tx});
                } else {
                    Agent.LOG.log(Level.FINEST, "Token {0} on transaction {1} removed due to cause {2}", new Object[]{token, tx, cause});
                }
                token.markExpired();
            }
        }).build();
    }

    @Override
    public int timedOutCount() {
        return this.timedOutTokens.get();
    }

    @Override
    public boolean remove(TokenImpl token) {
        return this.activeTokens.asMap().remove(token) != null;
    }

    @Override
    public void removeAll() {
        this.activeTokens.invalidateAll();
    }

    @Override
    public void put(TokenImpl token) {
        this.activeTokens.put(token, token);
    }

    @Override
    public void cleanUp() {
        this.activeTokens.cleanUp();
    }

    @Override
    public void refresh(TokenImpl token) {
        this.activeTokens.getIfPresent(token);
    }
}

