/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.BoundTransactionApiImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.bridge.AsyncApi;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.ServletAsyncTransactionStateImpl;
import com.newrelic.api.agent.Logger;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class AsyncApiImpl
implements AsyncApi {
    private final ConcurrentMap<Object, Transaction> asyncTransactions = new MapMaker().weakKeys().makeMap();
    private final Logger logger;

    public AsyncApiImpl(Logger logger) {
        this.logger = logger;
    }

    public void suspendAsync(Object asyncContext) {
        Transaction currentTxn;
        this.logger.log(Level.FINEST, "Suspend async", new Object[0]);
        if (asyncContext != null && (currentTxn = Transaction.getTransaction(false)) != null) {
            TransactionState transactionState = this.setTransactionState(currentTxn);
            transactionState.suspendRootTracer();
            this.asyncTransactions.put(asyncContext, currentTxn);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Suspended async: {0}, for Transaction: {1}", new Object[]{asyncContext, currentTxn});
            }
        }
    }

    private TransactionState setTransactionState(Transaction tx) {
        TransactionState txState = tx.getTransactionState();
        if (txState instanceof ServletAsyncTransactionStateImpl) {
            return txState;
        }
        txState = new ServletAsyncTransactionStateImpl(tx);
        tx.setTransactionState(txState);
        return txState;
    }

    public com.newrelic.agent.bridge.Transaction resumeAsync(Object asyncContext) {
        this.logger.log(Level.FINEST, "Resume async", new Object[0]);
        if (asyncContext != null) {
            Transaction suspendedTx = (Transaction)this.asyncTransactions.get(asyncContext);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Resume async: {0}, for Transaction: {1}", new Object[]{asyncContext, suspendedTx});
            }
            if (suspendedTx != null) {
                suspendedTx.getTransactionState().resume();
                if (suspendedTx.isStarted()) {
                    suspendedTx.getTransactionState().getRootTracer();
                    return new BoundTransactionApiImpl(suspendedTx);
                }
            }
        }
        return TransactionApiImpl.INSTANCE;
    }

    public void completeAsync(Object asyncContext) {
        this.logger.log(Level.FINEST, "Complete async", new Object[0]);
        if (asyncContext == null) {
            this.logger.log(Level.FINEST, "Complete async context is null", new Object[0]);
            return;
        }
        Transaction transaction = (Transaction)this.asyncTransactions.remove(asyncContext);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Complete async: {0}, for Transaction: {1}", new Object[]{asyncContext, transaction});
        }
        if (transaction != null) {
            transaction.getTransactionState().complete();
        }
    }

    public void errorAsync(Object asyncContext, Throwable t) {
        this.logger.log(Level.FINEST, "Error async", new Object[0]);
        if (asyncContext == null || t == null) {
            this.logger.log(Level.FINEST, "Error async context or throwable is null", new Object[0]);
            return;
        }
        Transaction transaction = (Transaction)this.asyncTransactions.get(asyncContext);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Error async: {0}, for Transaction: {1}", new Object[]{asyncContext, transaction});
        }
        if (transaction != null) {
            transaction.setThrowable(t, TransactionErrorPriority.API);
        }
    }

    public void finishRootTracer() {
        Tracer rootTracer;
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null && (rootTracer = currentTxn.getRootTracer()) != null) {
            rootTracer.finish(177, null);
        }
    }
}

