## MULTIPLE_WEAVE_ALL_METHODS ##

###Description###

This violation was raised because the @Weave class contains multiple methods annotated with @WeaveIntoAllMethods.

###Example###

####Original Class####
```
public class Example {

    public int getNumber();
    public String getString();

}
```


####Bad####
```
@Weave
public class Example {

    @WeaveIntoAllMethods
    public int instrumentation() {
       // record count
    };

    @WeaveIntoAllMethods
    public int secondInstrumentation() {
       // log
    };

}
```

----------

####Good####
```
@Weave
public class Example {

    @WeaveIntoAllMethods
    public int instrumentation() {
       // record count
       // log
    };
}
```

