/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.violation;

import com.newrelic.agent.deps.com.google.common.base.MoreObjects;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.weave.violation.WeaveViolationType;

public class WeaveViolation {
    private final WeaveViolationType type;
    private String clazz;
    private String field;
    private Method method;

    public WeaveViolation(WeaveViolationType type, String clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    public WeaveViolation(WeaveViolationType type, String clazz, String field) {
        this(type, clazz);
        this.field = field;
    }

    public WeaveViolation(WeaveViolationType type, String clazz, Method method) {
        this(type, clazz);
        this.method = method;
    }

    public WeaveViolationType getType() {
        return this.type;
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getField() {
        return this.field;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("type", (Object)this.type).add("clazz", this.clazz).add("field", this.field).add("method", this.method).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeaveViolation violation = (WeaveViolation)o;
        if (this.type != violation.type) {
            return false;
        }
        if (this.clazz != null ? !this.clazz.equals(violation.clazz) : violation.clazz != null) {
            return false;
        }
        if (this.field != null ? !this.field.equals(violation.field) : violation.field != null) {
            return false;
        }
        return !(this.method == null ? violation.method != null : !this.method.equals(violation.method));
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        return result;
    }
}

