/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataFetcher {
    protected static final Pattern LINUX_MEMORY_PATTERN = Pattern.compile("MemTotal: \\s+(\\d+)\\skB");
    protected static final Pattern LINUX_PROCESSOR_PATTERN = Pattern.compile("processor\\s*:\\s*([0-9]+)");

    public static long getTotalRamInMib() {
        String os = ManagementFactory.getOperatingSystemMXBean().getName();
        if (os.contains("Linux")) {
            String match = DataFetcher.findLastMatchInFile(new File("/proc/meminfo"), LINUX_MEMORY_PATTERN);
            if (match != null) {
                long ramInkB = DataFetcher.parseLongRam(match);
                return ramInkB / 1024L;
            }
        } else {
            if (os.contains("BSD")) {
                String output = DataFetcher.executeCommand("sysctl -n hw.realmem");
                long ramInBytes = DataFetcher.parseLongRam(output);
                return ramInBytes / 0x100000L;
            }
            if (os.contains("Mac")) {
                String output = DataFetcher.executeCommand("sysctl -n hw.memsize");
                long ramInBytes = DataFetcher.parseLongRam(output);
                return ramInBytes / 0x100000L;
            }
            if (os.contains("Windows")) {
                String output = DataFetcher.executeCommand("wmic ComputerSystem get TotalPhysicalMemory").replaceFirst("TotalPhysicalMemory", "").trim();
                long ramInBytes = DataFetcher.parseLongRam(output);
                return ramInBytes / 0x100000L;
            }
            Agent.LOG.log(Level.FINER, "Could not get total physical memory for OS {0}", new Object[]{os});
        }
        return 0L;
    }

    public static int getLogicalProcessorCount() {
        int linuxLogicalProcessors;
        String os = ManagementFactory.getOperatingSystemMXBean().getName();
        if (os.contains("Linux") && (linuxLogicalProcessors = DataFetcher.getLinuxLogicalProcessors(new File("/proc/cpuinfo"))) > 0) {
            return linuxLogicalProcessors;
        }
        return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }

    static int getLinuxLogicalProcessors(File procCpuInfo) {
        String match = DataFetcher.findLastMatchInFile(procCpuInfo, LINUX_PROCESSOR_PATTERN);
        if (null != match) {
            try {
                return Integer.parseInt(match) + 1;
            }
            catch (NumberFormatException nfe) {
                Agent.LOG.log(Level.FINE, "Unable to parse linux processors. Found {0}", new Object[]{match});
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findLastMatchInFile(File file, Pattern lookFor) {
        if (file.exists() && file.canRead()) {
            BufferedReader reader = null;
            try {
                String line;
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                reader = new BufferedReader(inputStreamReader);
                Matcher matcher = lookFor.matcher("");
                String lastMatch = null;
                while ((line = reader.readLine()) != null) {
                    matcher.reset(line);
                    if (!matcher.find()) continue;
                    lastMatch = matcher.group(1);
                }
                String string = lastMatch;
                return string;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Agent.LOG.log(Level.FINER, "Could not read file {0}", new Object[]{file.getName()});
        return null;
    }

    protected static long parseLongRam(String number) {
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            Agent.LOG.log(Level.FINE, "Unable to parse total memory available. Found {0}", new Object[]{number});
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeCommand(String command) {
        StringBuffer output = new StringBuffer();
        Process process = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(command);
            BufferedReader procOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = procOutput.readLine()) != null) {
                output.append(line);
            }
            process.waitFor();
        }
        catch (IOException e) {
            Agent.LOG.log(Level.FINEST, e, "An exception occurred running subprocess cmd: {0}", new Object[]{command});
        }
        catch (InterruptedException e) {
            Agent.LOG.log(Level.FINER, "Subprocess cmd interrupted: {0}", new Object[]{command});
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return output.toString();
    }
}

