/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.service.module.EmbeddedJars;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShaChecksums {
    private ShaChecksums() {
    }

    public static String computeSha(URL url) throws NoSuchAlgorithmException, IOException {
        return ShaChecksums.computeSha(EmbeddedJars.getInputStream(url));
    }

    public static String computeSha(File file) throws NoSuchAlgorithmException, IOException {
        return ShaChecksums.computeSha(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeSha(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            DigestInputStream dis = new DigestInputStream(inputStream, md);
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer(40);
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }
}

