/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.environment.AgentIdentity;
import com.newrelic.agent.environment.Environment;
import com.newrelic.agent.environment.EnvironmentService;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.analytics.AnalyticsEvent;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.TransactionStats;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class ErrorEvent
extends AnalyticsEvent {
    static final float UNASSIGNED = Float.NEGATIVE_INFINITY;
    static final int UNASSIGNED_INT = Integer.MIN_VALUE;
    static final String TYPE = "TransactionError";
    final String errorClass;
    final String errorMessage;
    String transactionName = "Unknown";
    float duration = Float.NEGATIVE_INFINITY;
    float queueDuration = Float.NEGATIVE_INFINITY;
    float externalDuration = Float.NEGATIVE_INFINITY;
    float databaseDuration = Float.NEGATIVE_INFINITY;
    float gcCumulative = Float.NEGATIVE_INFINITY;
    float databaseCallCount = Float.NEGATIVE_INFINITY;
    float externalCallCount = Float.NEGATIVE_INFINITY;
    String transactionGuid;
    String referringTransactionGuid;
    String syntheticsResourceId;
    String syntheticsMonitorId;
    String syntheticsJobId;
    int port = Integer.MIN_VALUE;
    Map<String, Object> agentAttributes;
    String appName;

    public ErrorEvent(String appName, TracedError tracedError) {
        super(TYPE, tracedError.getTimestampInMillis());
        this.appName = appName;
        this.errorClass = tracedError.getExceptionClass();
        this.errorMessage = tracedError.getMessage();
        this.assignPortUsingServiceManagerIfPossible();
    }

    private void assignPortUsingServiceManagerIfPossible() {
        Integer serverPort;
        AgentIdentity agentIdentity;
        Environment environment;
        EnvironmentService environmentService;
        ServiceManager serviceManager = ServiceFactory.getServiceManager();
        if (serviceManager != null && (environmentService = serviceManager.getEnvironmentService()) != null && (environment = environmentService.getEnvironment()) != null && (agentIdentity = environment.getAgentIdentity()) != null && (serverPort = agentIdentity.getServerPort()) != null) {
            this.port = serverPort;
        }
    }

    public ErrorEvent(String appName, TracedError tracedError, TransactionData transactionData, TransactionStats transactionStats) {
        super(TYPE, tracedError.getTimestampInMillis());
        this.appName = appName;
        this.errorClass = tracedError.getExceptionClass();
        this.errorMessage = tracedError.getMessage();
        this.transactionName = transactionData.getPriorityTransactionName().getName();
        this.duration = (float)transactionData.getDurationInMillis() / 1000.0f;
        this.queueDuration = this.retrieveMetricIfExists(transactionStats, "WebFrontend/QueueTime").getTotal();
        this.externalDuration = this.retrieveMetricIfExists(transactionStats, "External/all").getTotal();
        this.databaseDuration = this.retrieveMetricIfExists(transactionStats, "Datastore/all").getTotal();
        this.gcCumulative = this.retrieveMetricIfExists(transactionStats, "GC/cumulative").getTotal();
        this.databaseCallCount = this.retrieveMetricIfExists(transactionStats, "Datastore/all").getCallCount();
        this.externalCallCount = this.retrieveMetricIfExists(transactionStats, "External/all").getCallCount();
        this.transactionGuid = transactionData.getGuid();
        this.referringTransactionGuid = transactionData.getReferrerGuid();
        this.syntheticsResourceId = transactionData.getSyntheticsResourceId();
        this.syntheticsJobId = transactionData.getSyntheticsJobId();
        this.syntheticsMonitorId = transactionData.getSyntheticsMonitorId();
        this.assignPortUsingServiceManagerIfPossible();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForErrors(appName)) {
            this.userAttributes = transactionData.getUserAttributes();
            this.userAttributes.putAll(transactionData.getErrorAttributes());
            this.agentAttributes = transactionData.getAgentAttributes();
            this.agentAttributes.putAll(AttributesUtils.appendAttributePrefixes(transactionData.getPrefixedAttributes()));
        }
    }

    public String getErrorClass() {
        return this.errorClass;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("type", this.type);
        obj.put("error.class", this.errorClass);
        obj.put("error.message", this.errorMessage);
        obj.put("timestamp", this.timestamp);
        obj.put("transactionName", this.transactionName);
        if (this.duration != Float.NEGATIVE_INFINITY) {
            obj.put("duration", Float.valueOf(this.duration));
        }
        if (this.queueDuration != Float.NEGATIVE_INFINITY) {
            obj.put("queueDuration", Float.valueOf(this.queueDuration));
        }
        if (this.externalDuration != Float.NEGATIVE_INFINITY) {
            obj.put("externalDuration", Float.valueOf(this.externalDuration));
        }
        if (this.databaseDuration > 0.0f) {
            obj.put("databaseDuration", Float.valueOf(this.databaseDuration));
        }
        if (this.gcCumulative != Float.NEGATIVE_INFINITY) {
            obj.put("gcCumulative", Float.valueOf(this.gcCumulative));
        }
        if (this.databaseCallCount > 0.0f) {
            obj.put("databaseCallCount", Float.valueOf(this.databaseCallCount));
        }
        if (this.externalCallCount > 0.0f) {
            obj.put("externalCallCount", Float.valueOf(this.externalCallCount));
        }
        if (this.transactionGuid != null) {
            obj.put("nr.transactionGuid", this.transactionGuid);
        }
        if (this.referringTransactionGuid != null) {
            obj.put("nr.referringTransactionGuid", this.referringTransactionGuid);
        }
        if (this.syntheticsResourceId != null) {
            obj.put("nr.syntheticsResourceId", this.syntheticsResourceId);
        }
        if (this.syntheticsMonitorId != null) {
            obj.put("nr.syntheticsMonitorId", this.syntheticsMonitorId);
        }
        if (this.syntheticsJobId != null) {
            obj.put("nr.syntheticsJobId", this.syntheticsJobId);
        }
        if (this.port != Integer.MIN_VALUE) {
            obj.put("port", this.port);
        }
        Map<String, ? extends Object> filteredUserAtts = this.getUserFilteredMap(this.userAttributes);
        Map<String, ? extends Object> filteredAgentAtts = this.getFilteredMap(this.agentAttributes);
        if (filteredAgentAtts.isEmpty()) {
            if (filteredUserAtts.isEmpty()) {
                JSONArray.writeJSONString(Arrays.asList(obj), out);
            } else {
                JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts), out);
            }
        } else {
            JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts, filteredAgentAtts), out);
        }
    }

    private Map<String, ? extends Object> getFilteredMap(Map<String, Object> input) {
        return ServiceFactory.getAttributesService().filterErrorAttributes(this.appName, input);
    }

    private Map<String, ? extends Object> getUserFilteredMap(Map<String, Object> input) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return this.getFilteredMap(input);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private CountStats retrieveMetricIfExists(TransactionStats transactionStats, String metricName) {
        if (!transactionStats.getUnscopedStats().getStatsMap().containsKey(metricName)) {
            return NoCallCountStats.NO_STATS;
        }
        return transactionStats.getUnscopedStats().getResponseTimeStats(metricName);
    }

    private static class NoCallCountStats
    extends AbstractStats {
        static final NoCallCountStats NO_STATS = new NoCallCountStats();

        private NoCallCountStats() {
        }

        @Override
        public float getTotal() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getTotalExclusiveTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMinCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMaxCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public double getSumOfSquares() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public void merge(StatsBase stats) {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return NO_STATS;
        }
    }
}

