/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import com.newrelic.agent.bridge.AgentBridge;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ServiceUtils {
    private static final int ROTATED_BIT_SHIFT = 31;
    private static final String PATH_HASH_SEPARATOR = ";";
    private static final MessageDigest cloneableMd5Digest = ServiceUtils.initializeMd5Digest();

    public static int calculatePathHash(String appName, String txName, Integer optionalReferringPathHash) {
        int referringPathHash = optionalReferringPathHash == null ? 0 : optionalReferringPathHash;
        int rotatedReferringPathHash = referringPathHash << 1 | referringPathHash >>> 31;
        return rotatedReferringPathHash ^ ServiceUtils.getHash(appName, txName);
    }

    public static int reversePathHash(String appName, String txName, Integer optionalReferringPathHash) {
        int referringPathHash = optionalReferringPathHash == null ? 0 : optionalReferringPathHash;
        int rotatedReferringPathHash = referringPathHash ^ ServiceUtils.getHash(appName, txName);
        return rotatedReferringPathHash >>> 1 | rotatedReferringPathHash << 31;
    }

    private static int getHash(String appName, String txName) {
        try {
            if (cloneableMd5Digest == null) {
                return 0;
            }
            MessageDigest md = (MessageDigest)cloneableMd5Digest.clone();
            byte[] digest = md.digest((appName + PATH_HASH_SEPARATOR + txName).getBytes("UTF-8"));
            int fromBytes = (digest[12] & 0xFF) << 24 | (digest[13] & 0xFF) << 16 | (digest[14] & 0xFF) << 8 | digest[15] & 0xFF;
            return fromBytes;
        }
        catch (CloneNotSupportedException e) {
            return 0;
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
    }

    public static String intToHexString(int val) {
        return String.format("%08x", val);
    }

    public static int hexStringToInt(String val) {
        return (int)Long.parseLong(val, 16);
    }

    public static void readMemoryBarrier(AtomicInteger i) {
        if (i.get() == -1) {
            i.set(0);
        }
    }

    public static void writeMemoryBarrier(AtomicInteger i) {
        i.incrementAndGet();
    }

    private static MessageDigest initializeMd5Digest() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return (MessageDigest)messageDigest.clone();
        }
        catch (NoSuchAlgorithmException e) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, (Throwable)e, "No algorithm found for MD5 Digest", new Object[0]);
            return null;
        }
        catch (CloneNotSupportedException e) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, (Throwable)e, "Clone not supported for MD5 Digest", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, e, "Unable to initialize MD5 Digest", new Object[0]);
            return null;
        }
    }
}

