/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import java.lang.management.ThreadInfo;
import java.util.Map;
import java.util.Set;

public class RunnableThreadRules {
    private final Set<String> nonRunnableClasses = ImmutableSet.of("jrockit.net.SocketNativeIO");
    private final Map<String, String> classNameToNonRunnableMethodName = ImmutableMap.builder().put(Object.class.getName(), "wait").put("java.lang.UNIXProcess", "waitForProcessExit").put("sun.misc.Unsafe", "park").put("org.apache.tomcat.jni.Socket", "accept").put("org.apache.tomcat.jni.Poll", "poll").put("weblogic.socket.PosixSocketMuxer", "poll").put("weblogic.socket.NTSocketMuxer", "getIoCompletionResult").put("com.caucho.vfs.JniServerSocketImpl", "nativeAccept").build();

    public boolean isRunnable(ThreadInfo threadInfo) {
        if (!Thread.State.RUNNABLE.equals((Object)threadInfo.getThreadState())) {
            return false;
        }
        return this.isRunnable(threadInfo.getStackTrace());
    }

    public boolean isRunnable(StackTraceElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        return this.isRunnable(elements[0]);
    }

    public boolean isRunnable(StackTraceElement firstElement) {
        String nonRunnableMethodName;
        String className = firstElement.getClassName();
        if (this.nonRunnableClasses.contains(className)) {
            return false;
        }
        String methodName = firstElement.getMethodName();
        if (methodName.equals(nonRunnableMethodName = this.classNameToNonRunnableMethodName.get(className))) {
            return false;
        }
        if (!firstElement.isNativeMethod()) {
            return true;
        }
        if (className.startsWith("java.io.")) {
            return false;
        }
        if (className.startsWith("java.net.")) {
            return false;
        }
        return !className.startsWith("sun.nio.");
    }
}

