/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.weblogic;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.jmx.values.WeblogicJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class WeblogicStartUpPointCut
extends PointCut
implements EntryInvocationHandler {
    private boolean addedJmx = false;

    public WeblogicStartUpPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(WeblogicStartUpPointCut.class.getName(), null, true), WeblogicStartUpPointCut.createClassMatcher(), OrMethodMatcher.getMethodMatcher(WeblogicStartUpPointCut.createExactMethodMatcher("run", "([Ljava/lang/String;)I"), WeblogicStartUpPointCut.createExactMethodMatcher("run", "([Ljava/lang/String;)Lweblogic/t3/srvr/T3ServerFuture;")));
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("weblogic/t3/srvr/T3Srvr");
    }

    @Override
    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!this.addedJmx) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new WeblogicJmxValues());
            this.addedJmx = true;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Added JMX for Weblogic");
            }
        }
    }

    @Override
    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }
}

