/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.glassfish;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.values.GlassfishJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@PointCut
public class Glassfish4StartUpPointCut
extends TracerFactoryPointCut {
    private final AtomicBoolean addedJmx = new AtomicBoolean(false);

    public Glassfish4StartUpPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(Glassfish4StartUpPointCut.class.getName(), "glassfish_instrumentation", true), Glassfish4StartUpPointCut.createClassMatcher(), Glassfish4StartUpPointCut.createMethodMatcher());
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("com/sun/appserv/server/util/Version");
    }

    private static MethodMatcher createMethodMatcher() {
        return Glassfish4StartUpPointCut.createExactMethodMatcher("getMajorVersion", "()Ljava/lang/String;");
    }

    @Override
    public boolean isDispatcher() {
        return true;
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        if (!this.addedJmx.get()) {
            return new MethodExitTracer(sig, transaction){

                @Override
                protected void doFinish(int opcode, Object returnValue) {
                    block3: {
                        try {
                            String majorVersion;
                            if (returnValue instanceof String && (majorVersion = ((String)returnValue).trim()).length() > 0) {
                                Glassfish4StartUpPointCut.this.addJMX(majorVersion);
                            }
                        }
                        catch (Exception e) {
                            if (!Agent.LOG.isFinestEnabled()) break block3;
                            Agent.LOG.log(Level.FINER, "Glassfish Jmx error", e);
                        }
                    }
                }
            };
        }
        return null;
    }

    private void addJMX(String majorVersion) {
        if (!("1".equals(majorVersion) || "2".equals(majorVersion) || "3".equals(majorVersion))) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new GlassfishJmxValues());
            this.addedJmx.set(true);
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Added JMX for Glassfish {0}", majorVersion));
            }
        }
    }
}

