/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.amazon;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.AbstractTracerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@PointCut
public class AmazonS3ConectionPointCut
extends TracerFactoryPointCut {
    private static final Map<MethodMatcher, TracerFactory> methodMatcherTracers = Collections.unmodifiableMap(AmazonS3ConectionPointCut.createTracerFactories());

    public AmazonS3ConectionPointCut(PointCutClassTransformer classTransformer) {
        super(AmazonS3ConectionPointCut.class, (ClassMatcher)new ExactClassMatcher("com/amazon/s3/AWSAuthConnection"), OrMethodMatcher.getMethodMatcher(methodMatcherTracers.keySet().toArray(new MethodMatcher[0])));
    }

    private static Map<MethodMatcher, TracerFactory> createTracerFactories() {
        HashMap<MethodMatcher, TracerFactory> factories = new HashMap<MethodMatcher, TracerFactory>(){
            {
                AmazonS3ConectionPointCut.addBasicTracerFactory(this, "listAllMyBuckets", "(Ljava/util/Map;)Lcom/amazon/s3/ListAllMyBucketsResponse;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "createBucket", "(Ljava/lang/String;Ljava/util/Map;)Lcom/amazon/s3/Response;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "createBucket", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Lcom/amazon/s3/Response;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "listBucket", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/util/Map;)Lcom/amazon/s3/ListBucketResponse;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "listBucket", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/util/Map;)Lcom/amazon/s3/ListBucketResponse;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "deleteBucket", "(Ljava/lang/String;Ljava/util/Map;)Lcom/amazon/s3/Response;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "getBucketLocation", "(Ljava/lang/String;)Lcom/amazon/s3/LocationResponse;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "get", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Lcom/amazon/s3/GetResponse;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "put", "(Ljava/lang/String;Ljava/lang/String;Lcom/amazon/s3/S3Object;Ljava/util/Map;)Lcom/amazon/s3/Response;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Lcom/amazon/s3/Response;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)Lcom/amazon/s3/Response;");
                AmazonS3ConectionPointCut.addBucketTracerFactory(this, "delete", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Lcom/amazon/s3/Response;");
            }
        };
        return factories;
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        for (Map.Entry<MethodMatcher, TracerFactory> entry : methodMatcherTracers.entrySet()) {
            if (!entry.getKey().matches(-1, sig.getMethodName(), sig.getMethodDesc(), MethodMatcher.UNSPECIFIED_ANNOTATIONS)) continue;
            return entry.getValue().getTracer(transaction, sig, object, args);
        }
        return null;
    }

    private static void addBasicTracerFactory(Map<MethodMatcher, TracerFactory> map, String methodName, String methodDesc) {
        methodName = methodName.intern();
        methodDesc = methodDesc.intern();
        map.put(new ExactMethodMatcher(methodName, methodDesc), new BasicTracerFactory(methodName));
    }

    private static void addBucketTracerFactory(Map<MethodMatcher, TracerFactory> map, String methodName, String methodDesc) {
        methodName = methodName.intern();
        methodDesc = methodDesc.intern();
        map.put(new ExactMethodMatcher(methodName, methodDesc), new BucketTracerFactory(methodName));
    }

    private static class BucketTracerFactory
    extends BasicTracerFactory {
        public BucketTracerFactory(String operation) {
            super(operation);
        }

        @Override
        public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
            String host = "amazon";
            String uri = "";
            return new ExternalComponentTracer(transaction, sig, object, host, "S3", uri, this.getOperation(), (String)args[0]);
        }
    }

    private static class BasicTracerFactory
    extends AbstractTracerFactory {
        private final String operation;

        public BasicTracerFactory(String operation) {
            this.operation = operation;
        }

        public String getOperation() {
            return this.operation;
        }

        @Override
        public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
            String host = "amazon";
            String uri = "";
            return new ExternalComponentTracer(transaction, sig, object, host, "S3", uri, this.getOperation());
        }
    }
}

