/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.StripExceptionConfig;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.errors.ExceptionHandlerPointCut;
import com.newrelic.agent.errors.ExceptionHandlerSignature;
import com.newrelic.agent.errors.HttpTracedError;
import com.newrelic.agent.errors.ThrowableError;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.ErrorEvent;
import com.newrelic.agent.service.analytics.ReservoirSampledArrayList;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;

public class ErrorServiceImpl
implements ErrorService {
    public static final int ERROR_LIMIT_PER_REPORTING_PERIOD = 20;
    public static final String STRIPPED_EXCEPTION_REPLACEMENT = "Message removed by New Relic 'strip_exception_messages' setting";
    public static final Set<String> IGNORE_ERRORS;
    protected final AtomicInteger errorCountThisHarvest = new AtomicInteger();
    private final AtomicInteger errorCount = new AtomicInteger();
    private final AtomicLong totalErrorCount = new AtomicLong();
    private final AtomicReferenceArray<TracedError> tracedErrors;
    private final ConcurrentHashMap<String, ReservoirSampledArrayList<ErrorEvent>> errorEventReservoir;
    private volatile ErrorCollectorConfig errorCollectorConfig;
    private volatile StripExceptionConfig stripExceptionConfig;
    private final boolean shouldRecordErrorCount;
    private final String appName;
    protected final HarvestListener harvestListener = new HarvestListener(){

        @Override
        public void beforeHarvest(String appName, StatsEngine statsEngine) {
            ErrorServiceImpl.this.harvestEvents(appName, statsEngine);
        }

        @Override
        public void afterHarvest(String appName) {
        }
    };

    @Override
    public void start() {
        ServiceFactory.getHarvestService().addHarvestListener(this.harvestListener);
    }

    @Override
    public void stop() {
        ServiceFactory.getHarvestService().removeHarvestListener(this.harvestListener);
    }

    void harvestEvents(String appName, StatsEngine statsEngine) {
        boolean eventsEnabled = ServiceFactory.getConfigService().getErrorCollectorConfig(appName).isEventsEnabled();
        if (!eventsEnabled) {
            this.errorEventReservoir.remove(appName);
            return;
        }
        ReservoirSampledArrayList reservoir = this.errorEventReservoir.put(appName, new ReservoirSampledArrayList(this.errorCollectorConfig.getMaxEventsStored()));
        if (reservoir != null && reservoir.size() > 0) {
            try {
                ServiceFactory.getRPMService(appName).sendErrorEvents(this.errorCollectorConfig.getMaxEventsStored(), reservoir.getNumberOfTries(), Collections.unmodifiableList(reservoir));
                statsEngine.getStats("Supportability/Events/TransactionError/Sent").incrementCallCount(reservoir.size());
                statsEngine.getStats("Supportability/Events/TransactionError/Seen").incrementCallCount(reservoir.getNumberOfTries());
                if (reservoir.size() < reservoir.getNumberOfTries()) {
                    Agent.LOG.log(Level.WARNING, "Dropped {0} error events out of {1}.", new Object[]{reservoir.getNumberOfTries() - reservoir.size(), reservoir.getNumberOfTries()});
                }
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send error events. Unsent events will be included in the next harvest.");
                ReservoirSampledArrayList<ErrorEvent> currentReservoir = this.errorEventReservoir.get(appName);
                currentReservoir.addAll(reservoir);
            }
        }
    }

    private boolean isEnabledForApp(String appName) {
        return ServiceFactory.getConfigService().getErrorCollectorConfig(appName).isEnabled();
    }

    public ErrorServiceImpl(String appName) {
        this.appName = appName;
        this.errorCollectorConfig = ServiceFactory.getConfigService().getErrorCollectorConfig(appName);
        this.stripExceptionConfig = ServiceFactory.getConfigService().getStripExceptionConfig(appName);
        this.tracedErrors = new AtomicReferenceArray(20);
        this.errorEventReservoir = new ConcurrentHashMap();
        ServiceFactory.getTransactionService().addTransactionListener(new MyTransactionListener());
        ServiceFactory.getConfigService().addIAgentConfigListener(new MyConfigListener());
        this.shouldRecordErrorCount = !Boolean.getBoolean("com.newrelic.agent.errors.no_error_metric");
    }

    protected void refreshErrorCollectorConfig(AgentConfig agentConfig) {
        ErrorCollectorConfig oldErrorConfig = this.errorCollectorConfig;
        this.errorCollectorConfig = agentConfig.getErrorCollectorConfig();
        if (this.errorCollectorConfig.isEnabled() == oldErrorConfig.isEnabled()) {
            return;
        }
        String msg = MessageFormat.format("Errors will{0} be sent to New Relic for {1}", this.errorCollectorConfig.isEnabled() ? "" : " not", this.appName);
        Agent.LOG.info(msg);
    }

    protected void refreshStripExceptionConfig(AgentConfig agentConfig) {
        StripExceptionConfig oldStripExceptionConfig = this.stripExceptionConfig;
        this.stripExceptionConfig = agentConfig.getStripExceptionConfig();
        if (this.stripExceptionConfig.isEnabled() != oldStripExceptionConfig.isEnabled()) {
            Agent.LOG.info(MessageFormat.format("Exception messages will{0} be stripped before sending to New Relic for {1}", this.stripExceptionConfig.isEnabled() ? "" : " not", this.appName));
        }
        if (!this.stripExceptionConfig.getWhitelist().equals(oldStripExceptionConfig.getWhitelist())) {
            Agent.LOG.info(MessageFormat.format("Exception message whitelist updated to {0} for {1}", this.stripExceptionConfig.getWhitelist().toString(), this.appName));
        }
    }

    @Override
    public void reportError(TracedError error) {
        this.reportError(error, null, null, null);
    }

    public void reportError(TracedError error, TransactionData transactionData, TransactionStats transactionStats) {
        this.reportError(error, null, transactionData, transactionStats);
    }

    public void reportError(TracedError error, Transaction tx) {
        this.reportError(error, tx, null, null);
    }

    protected void reportError(TracedError error, Transaction tx, TransactionData transactionData, TransactionStats transactionStats) {
        if (error == null) {
            return;
        }
        if (error instanceof ThrowableError && this.isIgnoredError(200, ((ThrowableError)error).getThrowable())) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Throwable throwable = ((ThrowableError)error).getThrowable();
                String errorString = throwable == null ? "" : throwable.getClass().getName();
                String msg = MessageFormat.format("Ignoring error {0} for {1}", errorString, this.appName);
                Agent.LOG.finer(msg);
            }
            return;
        }
        if (error.incrementsErrorMetric()) {
            this.errorCountThisHarvest.incrementAndGet();
        }
        if (!this.errorCollectorConfig.isEnabled()) {
            return;
        }
        ReservoirSampledArrayList<ErrorEvent> eventList = this.getReservoir(this.appName);
        Integer slot = eventList.getSlot();
        if (slot != null) {
            ErrorEvent errorEvent = ErrorServiceImpl.createErrorEvent(this.appName, error, tx, transactionData, transactionStats);
            eventList.set(slot, errorEvent);
        }
        if (this.errorCount.get() >= 20) {
            Agent.LOG.finer(MessageFormat.format("Error limit exceeded for {0}: {1}", this.appName, error));
            return;
        }
        int index = (int)this.totalErrorCount.getAndIncrement() % 20;
        if (this.tracedErrors.compareAndSet(index, null, error)) {
            this.errorCount.getAndIncrement();
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Recording error for {0} : {1}", this.appName, error);
                Agent.LOG.finer(msg);
            }
        }
    }

    public static ErrorEvent createErrorEvent(String theAppName, TracedError error, Transaction tx, TransactionData transactionData, TransactionStats transactionStats) {
        ErrorEvent errorEvent = tx != null ? new ErrorEvent(theAppName, error, new TransactionData(tx, tx.getTransactionCounts().getTransactionSize()), tx.getTransactionActivity().getTransactionStats()) : (transactionData != null ? new ErrorEvent(theAppName, error, transactionData, transactionStats) : new ErrorEvent(theAppName, error));
        return errorEvent;
    }

    @Override
    public void reportErrors(TracedError ... errors) {
        for (TracedError error : errors) {
            this.reportError(error);
        }
    }

    @Override
    public List<TracedError> getTracedErrors() {
        ArrayList<TracedError> errors = new ArrayList<TracedError>(20);
        for (int i = 0; i < this.tracedErrors.length(); ++i) {
            TracedError error = this.tracedErrors.getAndSet(i, null);
            if (error == null) continue;
            this.errorCount.getAndDecrement();
            errors.add(error);
        }
        return errors;
    }

    @Override
    public List<TracedError> harvest(IRPMService rpmService, StatsEngine statsEngine) {
        if (!this.errorCollectorConfig.isEnabled()) {
            return Collections.emptyList();
        }
        this.recordMetrics(statsEngine);
        if (rpmService.isConnected()) {
            return this.getTracedErrors();
        }
        return Collections.emptyList();
    }

    private void recordMetrics(StatsEngine statsEngine) {
        int errorCount = this.errorCountThisHarvest.getAndSet(0);
        if (this.shouldRecordErrorCount) {
            statsEngine.getStats("Errors/all").incrementCallCount(errorCount);
        }
    }

    private void noticeTransaction(TransactionData td, TransactionStats transactionStats) {
        boolean isReportable;
        if (!this.appName.equals(td.getApplicationName())) {
            return;
        }
        if (!this.isEnabledForApp(td.getApplicationName())) {
            return;
        }
        String statusMessage = td.getStatusMessage();
        int responseStatus = td.getResponseStatus();
        Throwable throwable = td.getThrowable();
        boolean bl = isReportable = responseStatus >= 400 || throwable != null;
        if (throwable instanceof ReportableError) {
            statusMessage = throwable.getMessage();
            throwable = null;
        }
        if (isReportable) {
            if (!td.hasReportableErrorThatIsNotIgnored()) {
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String errorString = throwable == null ? "" : throwable.getClass().getName();
                    String msg = MessageFormat.format("Ignoring error {0} for {1} {2} ({3})", errorString, td.getRequestUri("error_collector"), this.appName, responseStatus);
                    Agent.LOG.finer(msg);
                }
                return;
            }
            TracedError error = ErrorServiceImpl.createTracedError(this.appName, td, throwable, responseStatus, statusMessage);
            if (this.shouldRecordErrorCount && error.incrementsErrorMetric()) {
                this.recordErrorCount(td, transactionStats);
            }
            this.reportError(error, td, transactionStats);
        }
    }

    public static TracedError createTracedError(String theAppName, TransactionData td, Throwable throwable, int responseStatus, String statusMessage) {
        TracedError error = throwable != null ? new ThrowableError(theAppName, td.getBlameOrRootMetricName(), td.getRequestUri("error_collector"), throwable, td.getWallClockStartTimeMs(), td.getPrefixedAttributes(), td.getUserAttributes(), td.getAgentAttributes(), td.getErrorAttributes(), td.getIntrinsicAttributes()) : new HttpTracedError(theAppName, td.getBlameOrRootMetricName(), td.getRequestUri("error_collector"), responseStatus, statusMessage, td.getWallClockStartTimeMs(), td.getPrefixedAttributes(), td.getUserAttributes(), td.getAgentAttributes(), td.getErrorAttributes(), td.getIntrinsicAttributes());
        return error;
    }

    private void recordErrorCount(TransactionData td, TransactionStats transactionStats) {
        String metricName = this.getErrorCountMetricName(td);
        if (metricName != null) {
            transactionStats.getUnscopedStats().getStats(metricName).incrementCallCount();
        }
        String metricNameAll = td.isWebTransaction() ? "Errors/allWeb" : "Errors/allOther";
        transactionStats.getUnscopedStats().getStats(metricNameAll).incrementCallCount();
    }

    private String getErrorCountMetricName(TransactionData td) {
        String blameMetricName = td.getBlameMetricName();
        if (blameMetricName != null) {
            StringBuilder output = new StringBuilder("Errors/".length() + blameMetricName.length());
            output.append("Errors/");
            output.append(blameMetricName);
            return output.toString();
        }
        return null;
    }

    private ReservoirSampledArrayList<ErrorEvent> getReservoir(String appName) {
        ReservoirSampledArrayList<ErrorEvent> result = this.errorEventReservoir.get(appName);
        while (result == null) {
            this.errorEventReservoir.putIfAbsent(appName, new ReservoirSampledArrayList(this.errorCollectorConfig.getMaxEventsStored()));
            result = this.errorEventReservoir.get(appName);
        }
        return result;
    }

    @Override
    public boolean isIgnoredError(int responseStatus, Throwable throwable) {
        if (this.errorCollectorConfig.getIgnoreStatusCodes().contains(responseStatus)) {
            return true;
        }
        return this.isIgnoredThrowable(throwable);
    }

    public boolean isIgnoredThrowable(Throwable throwable) {
        while (throwable != null) {
            String name = throwable.getClass().getName();
            if (this.errorCollectorConfig.getIgnoreErrors().contains(name)) {
                return true;
            }
            if (IGNORE_ERRORS.contains(name)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportException(Throwable throwable, Map<String, String> params) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null && tx.isInProgress()) {
            if (params != null) {
                tx.getErrorAttributes().putAll(params);
            }
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.setThrowable(throwable, TransactionErrorPriority.API);
            }
        } else {
            ThrowableError error = new ThrowableError(null, "Unknown", throwable, System.currentTimeMillis(), null, null, null, params, null);
            ServiceFactory.getRPMService().getErrorService().reportError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportError(String message, Map<String, String> params) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null && tx.isInProgress()) {
            if (params != null) {
                tx.getErrorAttributes().putAll(params);
            }
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.setThrowable(new ReportableError(message), TransactionErrorPriority.API);
            }
        } else {
            HttpTracedError error = new HttpTracedError(null, "Unknown", message, System.currentTimeMillis(), null, null, null, params, null);
            ServiceFactory.getRPMService().getErrorService().reportError(error);
        }
    }

    public static Collection<? extends PointCut> getEnabledErrorHandlerPointCuts() {
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        Object exceptionHandlers = config.getErrorCollectorConfig().getProperty("exception_handlers");
        if (exceptionHandlers == null) {
            return Collections.emptyList();
        }
        ArrayList<ExceptionHandlerPointCut> pointcuts = new ArrayList<ExceptionHandlerPointCut>();
        if (exceptionHandlers instanceof Collection) {
            for (Object sigObject : (Collection)exceptionHandlers) {
                ExceptionHandlerPointCut pc;
                if (sigObject instanceof ExceptionHandlerSignature) {
                    ExceptionHandlerSignature exHandlerSig = (ExceptionHandlerSignature)sigObject;
                    String msg = MessageFormat.format("Instrumenting exception handler signature {0}", exHandlerSig.toString());
                    Agent.LOG.finer(msg);
                    pc = new ExceptionHandlerPointCut(exHandlerSig);
                    if (!pc.isEnabled()) continue;
                    pointcuts.add(pc);
                    continue;
                }
                if (sigObject instanceof String) {
                    ClassMethodSignature signature = PointCutFactory.parseClassMethodSignature(sigObject.toString());
                    try {
                        ExceptionHandlerSignature exHandlerSig = new ExceptionHandlerSignature(signature);
                        Agent.LOG.info(MessageFormat.format("Instrumenting exception handler signature {0}", exHandlerSig.toString()));
                        pc = new ExceptionHandlerPointCut(exHandlerSig);
                        if (!pc.isEnabled()) continue;
                        pointcuts.add(pc);
                    }
                    catch (InvalidMethodDescriptor e) {
                        Agent.LOG.severe(MessageFormat.format("Unable to instrument exception handler {0} : {1}", sigObject.toString(), e.toString()));
                    }
                    continue;
                }
                if (!(sigObject instanceof Exception)) continue;
                Agent.LOG.severe(MessageFormat.format("Unable to instrument exception handler : {0}", sigObject.toString()));
            }
        }
        return pointcuts;
    }

    @Override
    public void reportHTTPError(String message, int statusCode, String uri) {
        if (!this.isIgnoredError(statusCode, null)) {
            HttpTracedError error = new HttpTracedError(null, "WebTransaction" + uri, uri, statusCode, message, System.currentTimeMillis(), null, null, null, null, null);
            this.reportError(error);
            Agent.LOG.finer(MessageFormat.format("Reported HTTP error {0} with status code {1} URI {2}", message, statusCode, uri));
        } else {
            Agent.LOG.finer(MessageFormat.format("Ignoring HTTP error {0} with status code {1} URI {2}", message, statusCode, uri));
        }
    }

    @Override
    public void reportException(Throwable throwable) {
        if (!this.isIgnoredThrowable(throwable)) {
            ErrorServiceImpl.reportException(throwable, Collections.<String, String>emptyMap());
        } else {
            Agent.LOG.finer(MessageFormat.format("Ignoring error with throwable {0} ", throwable));
        }
    }

    @Override
    public boolean useStrippedExceptionReplacement(Throwable throwable) {
        return this.stripExceptionConfig.isEnabled() && !this.stripExceptionConfig.getWhitelist().contains(throwable.getClass().getName());
    }

    public static String getStrippedExceptionMessage(Throwable throwable) {
        ErrorService errorService = ServiceFactory.getRPMService().getErrorService();
        if (errorService.useStrippedExceptionReplacement(throwable)) {
            return STRIPPED_EXCEPTION_REPLACEMENT;
        }
        return throwable.getMessage();
    }

    static {
        HashSet<String> ignoreErrors = new HashSet<String>(4);
        ignoreErrors.add("org.eclipse.jetty.continuation.ContinuationThrowable");
        ignoreErrors.add("org.mortbay.jetty.RetryRequest");
        IGNORE_ERRORS = Collections.unmodifiableSet(ignoreErrors);
    }

    private class MyConfigListener
    implements AgentConfigListener {
        private MyConfigListener() {
        }

        @Override
        public void configChanged(String appName, AgentConfig agentConfig) {
            if (ErrorServiceImpl.this.appName.equals(appName)) {
                Agent.LOG.fine(MessageFormat.format("Error service received configuration change notification for {0}", appName));
                ErrorServiceImpl.this.refreshErrorCollectorConfig(agentConfig);
                ErrorServiceImpl.this.refreshStripExceptionConfig(agentConfig);
            }
        }
    }

    private class MyTransactionListener
    implements TransactionListener {
        private MyTransactionListener() {
        }

        @Override
        public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
            ErrorServiceImpl.this.noticeTransaction(transactionData, transactionStats);
        }
    }

    public static class ReportableError
    extends Throwable {
        private static final long serialVersionUID = 3472056044517410355L;

        public ReportableError(String message) {
            super(message);
        }
    }
}

