/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ErrorCollectorConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ErrorCollectorConfigImpl
extends BaseConfig
implements ErrorCollectorConfig {
    public static final String ENABLED = "enabled";
    public static final String COLLECT_ERRORS = "collect_errors";
    public static final String IGNORE_STATUS_CODES = "ignore_status_codes";
    public static final String IGNORE_ERRORS = "ignore_errors";
    public static final String IGNORE_ERROR_PRIORITY_KEY = "error_collector.ignoreErrorPriority";
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_COLLECT_ERRORS = true;
    public static final Set<Integer> DEFAULT_IGNORE_STATUS_CODES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(404)));
    public static final String COLLECT_EVENTS = "collect_error_events";
    public static final boolean DEFAULT_COLLECT_EVENTS = true;
    public static final String CAPTURE_EVENTS = "capture_events";
    public static final boolean DEFAULT_CAPTURE_EVENTS = true;
    public static final String MAX_EVENT_SAMPLES_STORED = "max_event_samples_stored";
    public static final int DEFAULT_MAX_EVENT_SAMPLES_STORED = 100;
    public static final Set<String> DEFAULT_IGNORE_ERRORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("akka.actor.ActorKilledException")));
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.error_collector.";
    private final boolean isEnabled = this.initEnabled();
    private final Set<String> ignoreErrors = this.initIgnoreErrors();
    private final Set<Integer> ignoreStatusCodes = Collections.unmodifiableSet(this.getIntegerSet("ignore_status_codes", DEFAULT_IGNORE_STATUS_CODES));
    private final boolean isEventsEnabled = this.initEventsEnabled();
    private final int maxEventsStored = this.getIntProperty("max_event_samples_stored", 100);

    private ErrorCollectorConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
    }

    private Set<String> initIgnoreErrors() {
        Collection<String> uniqueErrors = this.getUniqueStrings(IGNORE_ERRORS);
        uniqueErrors = this.getProperty(IGNORE_ERRORS) == null ? DEFAULT_IGNORE_ERRORS : uniqueErrors;
        HashSet<String> result = new HashSet<String>(uniqueErrors.size());
        for (String uniqueError : uniqueErrors) {
            result.add(uniqueError.replace('/', '.'));
        }
        return Collections.unmodifiableSet(result);
    }

    private boolean initEnabled() {
        boolean isEnabled = this.getProperty(ENABLED, true);
        boolean canCollectErrors = this.getProperty(COLLECT_ERRORS, true);
        return isEnabled && canCollectErrors;
    }

    private boolean initEventsEnabled() {
        boolean collector = this.getProperty(COLLECT_EVENTS, true);
        boolean config = this.getProperty(CAPTURE_EVENTS, true);
        return collector && config;
    }

    @Override
    public Set<String> getIgnoreErrors() {
        return this.ignoreErrors;
    }

    @Override
    public Set<Integer> getIgnoreStatusCodes() {
        return this.ignoreStatusCodes;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isEventsEnabled() {
        return this.isEventsEnabled;
    }

    @Override
    public int getMaxEventsStored() {
        return this.maxEventsStored;
    }

    static ErrorCollectorConfig createErrorCollectorConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new ErrorCollectorConfigImpl(settings);
    }
}

