/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.browser;

import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.browser.BrowserConfigFactory;
import com.newrelic.agent.browser.BrowserService;
import com.newrelic.agent.browser.IBrowserConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BrowserServiceImpl
extends AbstractService
implements BrowserService,
ConnectionListener {
    private final ConcurrentMap<String, IBrowserConfig> browserConfigs = new ConcurrentHashMap<String, IBrowserConfig>();
    private volatile IBrowserConfig defaultBrowserConfig = null;
    private final String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();

    public BrowserServiceImpl() {
        super(BrowserService.class.getSimpleName());
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getRPMServiceManager().addConnectionListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getRPMServiceManager().removeConnectionListener(this);
    }

    @Override
    public IBrowserConfig getBrowserConfig(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultBrowserConfig;
        }
        return (IBrowserConfig)this.browserConfigs.get(appName);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void connected(IRPMService rpmService, Map<String, Object> serverData) {
        String appName = rpmService.getApplicationName();
        IBrowserConfig browserConfig = BrowserConfigFactory.createBrowserConfig(appName, serverData);
        if (appName == null || appName.equals(this.defaultAppName)) {
            this.defaultBrowserConfig = browserConfig;
        } else if (browserConfig == null) {
            this.browserConfigs.remove(appName);
        } else {
            this.browserConfigs.put(appName, browserConfig);
        }
    }

    @Override
    public void disconnected(IRPMService rpmService) {
    }
}

