/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.tracers.Tracer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class TokenImpl
implements Token {
    private volatile Tracer initiatingTracer;
    private final AtomicBoolean active;

    public TokenImpl(Tracer tracer) {
        this.initiatingTracer = tracer;
        this.active = new AtomicBoolean(Boolean.TRUE);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Create");
        }
    }

    public Transaction getTransaction() {
        if (this.initiatingTracer != null && this.initiatingTracer.getTransactionActivity() != null) {
            return this.initiatingTracer.getTransactionActivity().getTransaction();
        }
        return null;
    }

    public Tracer getInitiatingTracer() {
        return this.initiatingTracer;
    }

    public boolean expire() {
        if (this.active.compareAndSet(Boolean.TRUE, Boolean.FALSE)) {
            Transaction tx = this.getTransaction();
            if (tx != null) {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Expire");
            }
            boolean expired = Transaction.expireToken(this);
            this.initiatingTracer = null;
            return expired;
        }
        Agent.LOG.log(Level.FINER, "Token has already been expired {0}.", new Object[]{this});
        return false;
    }

    public boolean link() {
        boolean linked = Transaction.linkTxOnThread(this);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            if (linked) {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Link/Success");
            } else {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Link/Ignore");
            }
        }
        return linked;
    }

    public boolean linkAndExpire() {
        boolean linked = this.link();
        boolean expired = this.expire();
        return linked && expired;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void markExpired() {
        this.active.set(Boolean.FALSE);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.onRemoval();
        }
        this.initiatingTracer = null;
    }
}

