/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.com.google.common.collect.Queues;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.violation.WeaveViolationType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WeaveViolationFilter {
    private final Collection<WeaveViolationType> typesToFilter = EnumSet.noneOf(WeaveViolationType.class);
    private final String weavePackage;

    public WeaveViolationFilter(String weavePackage, Collection<WeaveViolationType> types) {
        this.typesToFilter.addAll(types);
        this.weavePackage = weavePackage;
    }

    public Collection<WeaveViolation> filterViolationCollection(Collection<WeaveViolation> violations) {
        ConcurrentLinkedQueue<WeaveViolation> newViolationCollection = Queues.newConcurrentLinkedQueue();
        for (WeaveViolation violation : violations) {
            if (this.shouldIgnoreViolation(violation)) continue;
            newViolationCollection.add(violation);
        }
        return newViolationCollection;
    }

    public boolean shouldIgnoreViolation(WeaveViolation violation) {
        return this.typesToFilter.contains((Object)violation.getType());
    }

    public String getWeavePackage() {
        return this.weavePackage;
    }
}

