/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.CloudVendor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class AzureAppService
implements CloudVendor {
    static String PROVIDER = "azureappservice";
    private final CloudUtility cloudUtility;
    private static final String CLOUD_RESOURCE_ID_KEY = "cloud.resource_id";

    public AzureAppService(CloudUtility cloudUtility) {
        this.cloudUtility = cloudUtility;
    }

    @Override
    public AzureAppServiceData getData() {
        String resourceGroup = System.getenv("WEBSITE_RESOURCE_GROUP");
        String siteName = System.getenv("WEBSITE_SITE_NAME");
        String ownerName = System.getenv("WEBSITE_OWNER_NAME");
        if (resourceGroup == null && siteName == null && ownerName == null) {
            return AzureAppServiceData.EMPTY_DATA;
        }
        return this.parseEnvVars(resourceGroup, siteName, ownerName);
    }

    protected AzureAppServiceData parseEnvVars(String resourceGroup, String siteName, String ownerName) {
        try {
            String subscriptionId;
            String string = subscriptionId = ownerName == null ? null : ownerName.split("\\+")[0];
            if ("".equals(resourceGroup) || this.cloudUtility.isInvalidValue(resourceGroup) || "".equals(siteName) || this.cloudUtility.isInvalidValue(siteName) || "".equals(subscriptionId) || this.cloudUtility.isInvalidValue(subscriptionId)) {
                this.recordAzureError();
                Agent.LOG.log(Level.WARNING, "Failed to validate Azure App Services value");
                return AzureAppServiceData.EMPTY_DATA;
            }
            AzureAppServiceData data = new AzureAppServiceData("/subscriptions/" + subscriptionId + "/resourceGroups/" + resourceGroup + "/providers/Microsoft.Web/sites/" + siteName);
            Agent.LOG.log(Level.FINEST, "Found AzureData {0}", data);
            return data;
        }
        catch (Exception e) {
            return AzureAppServiceData.EMPTY_DATA;
        }
    }

    private void recordAzureError() {
        this.cloudUtility.recordError("Supportability/utilization/azure/error");
    }

    protected static class AzureAppServiceData
    implements CloudData {
        private final String cloudResourceId;
        static final AzureAppServiceData EMPTY_DATA = new AzureAppServiceData();

        private AzureAppServiceData() {
            this.cloudResourceId = null;
        }

        protected AzureAppServiceData(String cloudResourceId) {
            this.cloudResourceId = cloudResourceId;
        }

        public String getCloudResourceId() {
            return this.cloudResourceId;
        }

        @Override
        public Map<String, String> getValueMap() {
            HashMap<String, String> azure = new HashMap<String, String>();
            if (this.cloudResourceId != null) {
                azure.put(AzureAppService.CLOUD_RESOURCE_ID_KEY, this.cloudResourceId);
            }
            return azure;
        }

        @Override
        public String getProvider() {
            return PROVIDER;
        }

        @Override
        public boolean isEmpty() {
            return this == EMPTY_DATA;
        }

        public String toString() {
            return "AzureAppServiceData{cloud.resource_id='" + this.cloudResourceId + "'" + '}';
        }
    }
}

