/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.deps.com.google.common.collect.MinMaxPriorityQueue;
import com.newrelic.agent.model.PriorityAware;
import com.newrelic.agent.util.MinAwareQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public final class SynchronizedMinAwareQueue<E extends PriorityAware>
implements MinAwareQueue<E> {
    private final MinMaxPriorityQueue<E> delegate;

    public SynchronizedMinAwareQueue(int reservoirSize, Comparator<E> comparator) {
        this.delegate = MinMaxPriorityQueue.orderedBy(comparator).maximumSize(reservoirSize).create();
    }

    @Override
    public synchronized boolean offer(E e) {
        return this.delegate.offer(e);
    }

    @Override
    public synchronized E poll() {
        return (E)((PriorityAware)this.delegate.poll());
    }

    @Override
    public synchronized E peek() {
        return (E)((PriorityAware)this.delegate.peek());
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    @Override
    public synchronized E peekLast() {
        return (E)((PriorityAware)this.delegate.peekLast());
    }

    @Override
    public synchronized boolean add(E e) {
        return this.delegate.add(e);
    }

    @Override
    public synchronized E remove() {
        return (E)((PriorityAware)this.delegate.remove());
    }

    @Override
    public synchronized E element() {
        return (E)((PriorityAware)this.delegate.element());
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }
}

