/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.attributes.AttributeValidator;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.Collections;
import java.util.Map;

public abstract class MethodExitTracerNoSkip
extends AbstractTracer {
    private final ClassMethodSignature signature;
    protected Tracer parentTracer;

    protected abstract void doFinish(int var1, Object var2);

    public MethodExitTracerNoSkip(ClassMethodSignature signature, Transaction transaction) {
        super(transaction);
        this.signature = signature;
        this.parentTracer = transaction.getTransactionActivity().getLastTracer();
    }

    public MethodExitTracerNoSkip(ClassMethodSignature signature, TransactionActivity activity) {
        super(activity, new AttributeValidator("custom"));
        this.signature = signature;
        this.parentTracer = activity == null ? null : activity.getLastTracer();
    }

    @Override
    public void childTracerFinished(Tracer child) {
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    public final void finish(int opcode, Object returnValue) {
        try {
            this.doFinish(opcode, returnValue);
        }
        finally {
            if (this.getTransaction() != null) {
                this.getTransaction().getTransactionActivity().tracerFinished(this, opcode);
            }
        }
    }

    public void finish(Throwable throwable) {
    }

    @Override
    public Tracer getParentTracer() {
        return this.parentTracer;
    }

    @Override
    public void setParentTracer(Tracer tracer) {
        this.parentTracer = tracer;
    }

    @Override
    public final ClassMethodSignature getClassMethodSignature() {
        return this.signature;
    }

    @Override
    public final long getDurationInMilliseconds() {
        return 0L;
    }

    @Override
    public final long getRunningDurationInNanos() {
        return 0L;
    }

    @Override
    public final long getDuration() {
        return 0L;
    }

    @Override
    public final long getExclusiveDuration() {
        return 0L;
    }

    @Override
    public final long getStartTime() {
        return 0L;
    }

    @Override
    public final long getStartTimeInMilliseconds() {
        return 0L;
    }

    @Override
    public final long getEndTime() {
        return 0L;
    }

    @Override
    public final long getEndTimeInMilliseconds() {
        return 0L;
    }

    @Override
    public final String getMetricName() {
        return null;
    }

    @Override
    public String getTransactionSegmentName() {
        return null;
    }

    @Override
    public String getTransactionSegmentUri() {
        return null;
    }

    @Override
    public final Map<String, Object> getAgentAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public Object getAgentAttribute(String key) {
        return null;
    }

    @Override
    public void setAgentAttribute(String key, Object value) {
    }

    @Override
    public final boolean isTransactionSegment() {
        return false;
    }

    @Override
    public void removeAgentAttribute(String key) {
    }

    public final boolean isMetricProducer() {
        return false;
    }

    @Override
    public boolean isParent() {
        return false;
    }

    @Override
    public void removeTransactionSegment() {
    }

    @Override
    public final TransactionSegment getTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(ttConfig, sqlObfuscator, startTime, this);
    }

    public void setMetricName(String ... metricNameParts) {
    }

    public void setMetricNameFormatInfo(String metricName, String transactionSegmentName, String transactionSegmentUri) {
    }

    @Override
    public String getGuid() {
        return null;
    }
}

