/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.SqlTracerExplainInfo;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.StackTraces;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class TransactionSegment
implements JSONStreamAware {
    private static final String PARTIAL_TRACE = "partialtrace";
    private static final Pattern INSERT_INTO_VALUES_STATEMENT = Pattern.compile("\\s*insert\\s+into\\s+([^\\s(,]*)\\s+values.*", 2);
    private static final String URL_PARAMETER_NAME = "http.url";
    public static final String ASYNC_EXCLUSIVE = "exclusive_duration_millis";
    private static final double NANO_TO_MILLI = 1000000.0;
    private final String appName;
    private String metricName;
    private final List<TransactionSegment> children;
    private final long entryTimestamp;
    private long exitTimestamp;
    private final Map<String, Object> tracerAttributes;
    private int callCount = 1;
    private final String uri;
    private final SqlObfuscator sqlObfuscator;
    private final TransactionTracerConfig ttConfig;
    private final List<StackTraceElement> parentStackTrace;
    private final ClassMethodSignature classMethodSignature;

    public TransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, Tracer tracer) {
        this(ttConfig, tracer.getTransactionActivity().getTransaction().getApplicationName(), sqlObfuscator, startTime, tracer, null);
    }

    TransactionSegment(TransactionTracerConfig ttConfig, String appName, SqlObfuscator sqlObfuscator, long startTime, Tracer tracer, TransactionSegment childSegment) {
        this.appName = appName;
        this.ttConfig = ttConfig;
        this.sqlObfuscator = sqlObfuscator;
        this.metricName = TransactionSegment.getMetricName(tracer);
        this.uri = TransactionSegment.getUri(tracer);
        if (childSegment == null) {
            this.children = new ArrayList<TransactionSegment>();
        } else {
            this.children = new ArrayList<TransactionSegment>(1);
            this.children.add(childSegment);
        }
        this.entryTimestamp = tracer.getStartTimeInMilliseconds() - startTime;
        this.exitTimestamp = tracer.getEndTimeInMilliseconds() - startTime;
        this.tracerAttributes = this.getTracerAttributes(tracer);
        this.classMethodSignature = tracer.getClassMethodSignature();
        this.parentStackTrace = this.getParentStackTrace(tracer);
    }

    private List<StackTraceElement> getParentStackTrace(Tracer tracer) {
        if (tracer.getParentTracer() != null) {
            return (List)tracer.getParentTracer().getAgentAttribute("backtrace");
        }
        return null;
    }

    private Map<String, Object> getTracerAttributes(Tracer tracer) {
        Object sql;
        if (tracer instanceof SqlTracerExplainInfo && (sql = ((SqlTracerExplainInfo)((Object)tracer)).getSql()) != null) {
            tracer.setAgentAttribute("sql", sql);
        }
        double exclusiveDur = (double)tracer.getExclusiveDuration() / 1000000.0;
        tracer.setAgentAttribute(ASYNC_EXCLUSIVE, exclusiveDur);
        return tracer.getAgentAttributes();
    }

    void resetExitTimeStampInMs(long duration) {
        this.exitTimestamp = duration;
    }

    public static String getMetricName(Tracer tracer) {
        String metricName = tracer.getTransactionSegmentName();
        if (metricName == null || metricName.trim().length() == 0) {
            if (Agent.isDebugEnabled()) {
                throw new RuntimeException(MessageFormat.format("Encountered a transaction segment with an invalid metric name. {0}", tracer.getClass().getName()));
            }
            metricName = tracer.getClass().getName() + "*";
        }
        return metricName;
    }

    public Map<String, Object> getTraceParameters() {
        return Collections.unmodifiableMap(this.tracerAttributes);
    }

    private static String getUri(Tracer tracer) {
        boolean excludeRequestUri = ServiceFactory.getConfigService().getDefaultAgentConfig().getExternalTracerConfig().excludeRequestUri();
        if (excludeRequestUri) {
            return null;
        }
        return tracer.getTransactionSegmentUri();
    }

    void setMetricName(String name) {
        if (name != null && name.trim().length() > 0) {
            this.metricName = name;
        }
    }

    public Collection<TransactionSegment> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void addChild(TransactionSegment sample) {
        try {
            this.children.add(sample);
        }
        catch (UnsupportedOperationException e) {
            String msg = MessageFormat.format("Unable to add transaction segment {0} to parent segment {1}", sample, this);
            Agent.LOG.info(msg);
        }
    }

    public String toString() {
        return this.metricName;
    }

    public long getStartTime() {
        return this.entryTimestamp;
    }

    public long getEndTime() {
        return this.exitTimestamp;
    }

    public String getClassName() {
        return this.classMethodSignature.getClassName();
    }

    public String getMethodName() {
        return this.classMethodSignature.getMethodName();
    }

    public int getCallCount() {
        return this.callCount;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(this.tracerAttributes);
        this.processStackTraces(params);
        this.processSqlParams(params);
        if (this.callCount > 1) {
            params.put("call_count", this.callCount);
        }
        if (this.uri != null && this.uri.length() > 0) {
            params.put(URL_PARAMETER_NAME, this.uri);
        }
        Map<String, ?> filteredAtts = ServiceFactory.getAttributesService().filterTransactionSegmentAttributes(this.appName, params);
        JSONArray.writeJSONString(Arrays.asList(this.entryTimestamp, this.exitTimestamp, this.metricName, filteredAtts, this.children, this.classMethodSignature.getClassName(), this.classMethodSignature.getMethodName()), writer);
    }

    private void processSqlParams(Map<String, Object> params) {
        Object sqlObj = params.remove("sql");
        if (sqlObj == null) {
            return;
        }
        Object obfuscatedSqlObject = params.remove("sql_obfuscated");
        String sql = obfuscatedSqlObject == null ? this.sqlObfuscator.obfuscateSql(sqlObj.toString()) : (this.sqlObfuscator.isObfuscating() ? obfuscatedSqlObject.toString() : sqlObj.toString());
        if (sql == null) {
            return;
        }
        if (INSERT_INTO_VALUES_STATEMENT.matcher(sql).matches()) {
            int maxLength = this.ttConfig.getInsertSqlMaxLength();
            sql = TransactionSegment.truncateSql(sql, maxLength);
        }
        if (this.ttConfig.isLogSql()) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("{0} SQL: {1}", this.ttConfig.getRecordSql(), sql));
            return;
        }
        params.put(this.sqlObfuscator.isObfuscating() ? "sql_obfuscated" : "sql", sql);
    }

    private void processStackTraces(Map<String, Object> params) {
        List backtrace = (List)params.remove("backtrace");
        if (backtrace != null) {
            List<StackTraceElement> preStackTraces = StackTraces.scrubAndTruncate(backtrace);
            List<String> postParentRemovalTrace = StackTraces.toStringListRemoveParent(preStackTraces, this.parentStackTrace);
            if (preStackTraces.size() == postParentRemovalTrace.size()) {
                params.put("backtrace", postParentRemovalTrace);
            } else {
                params.put(PARTIAL_TRACE, postParentRemovalTrace);
            }
        }
    }

    public void merge(Tracer tracer) {
        ++this.callCount;
        this.exitTimestamp += tracer.getDurationInMilliseconds();
    }

    public static String truncateSql(String sql, int maxLength) {
        int len = sql.length();
        if (len > maxLength) {
            return MessageFormat.format("{0}..({1} more chars)", sql.substring(0, maxLength), len - maxLength);
        }
        return sql;
    }
}

