/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.service.module.EmbeddedJars;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShaChecksums {
    private ShaChecksums() {
    }

    public static String computeSha(URL url) throws NoSuchAlgorithmException, IOException {
        return ShaChecksums.computeSha(EmbeddedJars.getInputStream(url));
    }

    public static String computeSha(File file) throws NoSuchAlgorithmException, IOException {
        return ShaChecksums.computeSha(new FileInputStream(file));
    }

    public static String computeSha(InputStream inputStream2) throws NoSuchAlgorithmException, IOException {
        return ShaChecksums.computeSha(inputStream2, "SHA1");
    }

    public static String computeSha512(URL url) throws NoSuchAlgorithmException, IOException {
        return ShaChecksums.computeSha512(EmbeddedJars.getInputStream(url));
    }

    private static String computeSha512(InputStream inputStream2) throws NoSuchAlgorithmException, IOException {
        return ShaChecksums.computeSha(inputStream2, "SHA-512");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String computeSha(InputStream inputStream2, String algorithm) throws NoSuchAlgorithmException, IOException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            DigestInputStream dis = new DigestInputStream(inputStream2, md);
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer(40);
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            inputStream2.close();
        }
    }
}

