/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.DebugFlag;
import com.newrelic.agent.config.JarResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class AgentJarHelper {
    private static final String AGENT_CLASS_NAME = "com/newrelic/agent/Agent.class";
    private static final String NEW_RELIC_JAR_FILE = "newrelic.jar";
    private static final String BUILT_DATE_ATTRIBUTE = "Built-Date";

    public static Collection<String> findAgentJarFileNames(Pattern pattern) {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        if (AgentJarHelper.isNewRelicDebug()) {
            System.out.println("Searching for " + pattern.pattern() + " in " + agentJarUrl.getPath());
        }
        return AgentJarHelper.findJarFileNames(agentJarUrl, pattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<String> findJarFileNames(URL agentJarUrl, Pattern pattern) {
        try (JarFile jarFile = AgentJarHelper.getAgentJarFile(agentJarUrl);){
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!pattern.matcher(jarEntry.getName()).matches()) continue;
                names.add(jarEntry.getName());
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (Exception e) {
            AgentJarHelper.logIfNRDebug("Unable to search the agent jar for " + pattern.pattern(), e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarFileNameExists(URL agentJarUrl, String name) {
        try (JarFile jarFile = AgentJarHelper.getAgentJarFile(agentJarUrl);){
            boolean bl = jarFile.getEntry(name) != null;
            return bl;
        }
        catch (Exception e) {
            AgentJarHelper.logIfNRDebug("Unable to search the agent jar for " + name, e);
            return false;
        }
    }

    public static File getAgentJarDirectory() {
        File file;
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        if (agentJarUrl != null && (file = new File(AgentJarHelper.getAgentJarFileName(agentJarUrl))).exists()) {
            return file.getParentFile();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL getAgentJarUrl() {
        URL[] urls;
        ClassLoader classLoader;
        if (System.getProperty("newrelic.agent_jarfile") != null) {
            try {
                return new URL("file://" + System.getProperty("newrelic.agent_jarfile"));
            }
            catch (MalformedURLException e) {
                AgentJarHelper.logIfNRDebug("Unable to create a valid url from " + System.getProperty("newrelic.agent_jarfile"), e);
            }
        }
        if (!((classLoader = AgentJarHelper.class.getClassLoader()) instanceof URLClassLoader)) return AgentJarHelper.class.getProtectionDomain().getCodeSource().getLocation();
        for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
            if (!url.getFile().endsWith(NEW_RELIC_JAR_FILE) || !AgentJarHelper.jarFileNameExists(url, AGENT_CLASS_NAME)) continue;
            return url;
        }
        String agentClassName = AGENT_CLASS_NAME.replace('.', '/');
        URL[] uRLArray = urls;
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            try (JarFile jarFile = new JarFile(url.getFile());){
                ZipEntry entry = jarFile.getEntry(agentClassName);
                if (entry != null) {
                    URL uRL = url;
                    return uRL;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
        return AgentJarHelper.class.getProtectionDomain().getCodeSource().getLocation();
    }

    public static JarResource getAgentJarResource() {
        final JarFile agentJarFile = AgentJarHelper.getAgentJarFile();
        if (agentJarFile == null) {
            return new JarResource(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public InputStream getInputStream(String name) {
                    return AgentJarHelper.class.getResourceAsStream('/' + name);
                }

                @Override
                public long getSize(String name) {
                    return 128L;
                }
            };
        }
        return new JarResource(){

            @Override
            public void close() throws IOException {
                agentJarFile.close();
            }

            @Override
            public InputStream getInputStream(String name) throws IOException {
                JarEntry entry = agentJarFile.getJarEntry(name);
                return agentJarFile.getInputStream(entry);
            }

            @Override
            public long getSize(String name) {
                JarEntry entry = agentJarFile.getJarEntry(name);
                return entry.getSize();
            }
        };
    }

    private static JarFile getAgentJarFile() {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        return AgentJarHelper.getAgentJarFile(agentJarUrl);
    }

    private static JarFile getAgentJarFile(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return new JarFile(AgentJarHelper.getAgentJarFileName(agentJarUrl));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getAgentJarFileName(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return URLDecoder.decode(agentJarUrl.getFile().replace("+", "%2B"), "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getAgentJarFileName() {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        return AgentJarHelper.getAgentJarFileName(agentJarUrl);
    }

    public static String getBuildDate() {
        return AgentJarHelper.getAgentJarAttribute(BUILT_DATE_ATTRIBUTE);
    }

    public static String getAgentJarAttribute(String name) {
        JarFile jarFile = AgentJarHelper.getAgentJarFile();
        if (jarFile == null) {
            return null;
        }
        try {
            return jarFile.getManifest().getMainAttributes().getValue(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static final boolean isNewRelicDebug() {
        return DebugFlag.DEBUG;
    }

    private static final void logIfNRDebug(String msg, Throwable th) {
        if (AgentJarHelper.isNewRelicDebug()) {
            System.out.println("While bootstrapping the Agent: " + msg + ": " + th.getStackTrace());
        }
    }
}

