/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ModuleExportNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ModuleNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ModuleOpenNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ModuleProvideNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ModuleRequireNode;
import com.newrelic.weave.utils.SynchronizedModuleExportNode;
import com.newrelic.weave.utils.SynchronizedModuleOpenNode;
import com.newrelic.weave.utils.SynchronizedModuleProvideNode;
import com.newrelic.weave.utils.SynchronizedModuleRequireNode;
import java.util.ArrayList;
import java.util.List;

public class SynchronizedModuleNode
extends ModuleNode {
    public SynchronizedModuleNode(String name, int access, String version) {
        super(name, access, version);
    }

    public SynchronizedModuleNode(int api, String name, int access, String version, List<ModuleRequireNode> requires, List<ModuleExportNode> exports, List<ModuleOpenNode> opens, List<String> uses, List<ModuleProvideNode> provides) {
        super(api, name, access, version, requires, exports, opens, uses, provides);
    }

    @Override
    public void visitRequire(String module, int access, String version) {
        if (this.requires == null) {
            this.requires = new ArrayList(5);
        }
        this.requires.add(new SynchronizedModuleRequireNode(module, access, version));
    }

    @Override
    public void visitExport(String packaze, int access, String ... modules) {
        if (this.exports == null) {
            this.exports = new ArrayList(5);
        }
        ArrayList<String> moduleList = null;
        if (modules != null) {
            moduleList = new ArrayList<String>(modules.length);
            for (int i = 0; i < modules.length; ++i) {
                moduleList.add(modules[i]);
            }
        }
        this.exports.add(new SynchronizedModuleExportNode(packaze, access, moduleList));
    }

    @Override
    public void visitOpen(String packaze, int access, String ... modules) {
        if (this.opens == null) {
            this.opens = new ArrayList(5);
        }
        ArrayList<String> moduleList = null;
        if (modules != null) {
            moduleList = new ArrayList<String>(modules.length);
            for (int i = 0; i < modules.length; ++i) {
                moduleList.add(modules[i]);
            }
        }
        this.opens.add(new SynchronizedModuleOpenNode(packaze, access, moduleList));
    }

    @Override
    public void visitProvide(String service, String ... providers) {
        if (this.provides == null) {
            this.provides = new ArrayList(5);
        }
        ArrayList<String> providerList = null;
        if (providers != null) {
            providerList = new ArrayList<String>(providers.length);
            for (int i = 0; i < providers.length; ++i) {
                providerList.add(providers[i]);
            }
        }
        this.provides.add(new SynchronizedModuleProvideNode(service, providerList));
    }

    @Override
    public synchronized void accept(ClassVisitor cv) {
        super.accept(cv);
    }
}

