/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.events;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.EventBatchSenderFactory;
import com.newrelic.telemetry.Response;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.events.EventBatch;
import com.newrelic.telemetry.events.json.EventBatchMarshaller;
import com.newrelic.telemetry.exceptions.ResponseException;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.transport.BatchDataSender;
import com.newrelic.telemetry.util.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Supplier;

public class EventBatchSender {
    private static final String EVENTS_PATH = "/v1/accounts/events";
    private static final String DEFAULT_URL = "https://insights-collector.newrelic.com";
    private static final String EUROPEAN_URL = "https://insights-collector.eu01.nr-data.net";
    private static final Response EMPTY_BATCH_RESPONSE = new Response(202, "Ignored", "Empty batch");
    private static final Logger logger = LoggerFactory.getLogger(EventBatchSender.class);
    private final EventBatchMarshaller marshaller;
    private final BatchDataSender sender;

    EventBatchSender(EventBatchMarshaller marshaller, BatchDataSender sender) {
        this.marshaller = marshaller;
        this.sender = sender;
    }

    public Response sendBatch(EventBatch batch) throws ResponseException {
        if (batch == null || batch.size() == 0) {
            logger.debug("Skipped sending of an empty event batch.");
            return EMPTY_BATCH_RESPONSE;
        }
        logger.debug("Sending an event batch (number of events: {}) to the New Relic event ingest endpoint)", (Object)batch.size());
        String json = this.marshaller.toJson(batch);
        return this.sender.send(json, batch);
    }

    public static EventBatchSender create(Supplier<HttpPoster> httpPosterCreator, BaseConfig baseConfig) {
        return EventBatchSender.create(EventBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(baseConfig).build());
    }

    public static EventBatchSender create(SenderConfiguration configuration) {
        Utils.verifyNonNull(configuration.getApiKey(), "API key cannot be null");
        Utils.verifyNonNull(configuration.getHttpPoster(), "an HttpPoster implementation is required.");
        String userRegion = configuration.getRegion();
        String defaultUrl = "https://insights-collector.newrelic.com/v1/accounts/events";
        String endpointUrlToString = configuration.getEndpointUrl().toString();
        URL url = null;
        if (!endpointUrlToString.equals(defaultUrl)) {
            url = configuration.getEndpointUrl();
        } else {
            try {
                url = EventBatchSender.returnEndpoint(userRegion);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        EventBatchMarshaller marshaller = new EventBatchMarshaller();
        BatchDataSender sender = new BatchDataSender(configuration.getHttpPoster(), configuration.getApiKey(), url, configuration.isAuditLoggingEnabled(), configuration.getSecondaryUserAgent(), configuration.useLicenseKey());
        return new EventBatchSender(marshaller, sender);
    }

    public static URL returnEndpoint(String userRegion) throws MalformedURLException {
        URL url = null;
        if (userRegion.equals("US")) {
            try {
                url = new URL("https://insights-collector.newrelic.com/v1/accounts/events");
                return url;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (userRegion.equals("EU")) {
            try {
                url = new URL("https://insights-collector.eu01.nr-data.net/v1/accounts/events");
                return url;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        throw new MalformedURLException("A valid region (EU or US) needs to be added to generate the right endpoint");
    }

    public static SenderConfiguration.SenderConfigurationBuilder configurationBuilder() {
        return SenderConfiguration.builder(DEFAULT_URL, EVENTS_PATH);
    }
}

