/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import java.net.URI;
import java.time.Duration;
import java.util.function.Function;

public class DaemonConfig {
    static final int DEFAULT_JMX_PORT = 1099;
    private static final String DEFAULT_DAEMON_VERSION = "UNKNOWN-VERSION";
    private static final String DEFAULT_JMX_HOST = "localhost";
    private static final boolean DEFAULT_USE_SHARED_FILESYSTEM = false;
    private static final boolean DEFAULT_USE_LICENSE_KEY = false;
    private static final boolean DEFAULT_AUDIT_LOGGING = false;
    public static final int DEFAULT_HARVEST_INTERVAL = 10;
    private static final Duration DEFAULT_HARVEST_DURATION = Duration.ofSeconds(10L);
    public static final Integer DEFAULT_QUEUE_SIZE = 250000;
    private static final String DEFAULT_MONITORED_APP_NAME = "My Application";
    private static final String DEFAULT_PROXY_HOST = null;
    private static final Integer DEFAULT_PROXY_PORT = null;
    private static final String DEFAULT_PROXY_SCHEME = null;
    private static final String DEFAULT_PROXY_USER = null;
    private static final String DEFAULT_PROXY_PASSWORD = null;
    private final String apiKey;
    private final URI metricsUri;
    private final URI eventsUri;
    private final String jmxHost;
    private final Integer jmxPort;
    private final boolean useSharedFilesystem;
    private final Duration harvestInterval;
    private final Integer queueSize;
    private final String daemonVersion;
    private final String monitoredAppName;
    private final boolean auditLogging;
    private final boolean useLicenseKey;
    private final String proxyHost;
    private final Integer proxyPort;
    private final String proxyUser;
    private final String proxyPassword;
    private final String proxyScheme;
    private final String threadNamePattern;

    public DaemonConfig(Builder builder) {
        this.auditLogging = builder.auditLogging;
        this.apiKey = builder.apiKey;
        this.metricsUri = builder.metricsUri;
        this.eventsUri = builder.eventsUri;
        this.jmxHost = builder.jmxHost;
        this.jmxPort = builder.jmxPort;
        this.useSharedFilesystem = builder.useSharedFilesystem;
        this.useLicenseKey = builder.useLicenseKey;
        this.harvestInterval = builder.harvestInterval;
        this.queueSize = builder.queueSize;
        this.daemonVersion = builder.daemonVersion;
        this.monitoredAppName = builder.monitoredAppName;
        this.proxyHost = builder.proxyHost;
        this.proxyPort = builder.proxyPort;
        this.proxyUser = builder.proxyUser;
        this.proxyPassword = builder.proxyPassword;
        this.proxyScheme = builder.proxyScheme;
        this.threadNamePattern = builder.threadNamePattern;
    }

    public boolean auditLogging() {
        return this.auditLogging;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public URI getMetricsUri() {
        return this.metricsUri;
    }

    public URI getEventsUri() {
        return this.eventsUri;
    }

    public String getJmxHost() {
        return this.jmxHost;
    }

    public Integer getJmxPort() {
        return this.jmxPort;
    }

    public boolean useSharedFilesystem() {
        return this.useSharedFilesystem;
    }

    public boolean useLicenseKey() {
        return this.useLicenseKey;
    }

    public boolean streamFromJmx() {
        return !this.useSharedFilesystem;
    }

    public Duration getHarvestInterval() {
        return this.harvestInterval;
    }

    public Integer getQueueSize() {
        return this.queueSize;
    }

    public String getDaemonVersion() {
        return this.daemonVersion;
    }

    public String getMonitoredAppName() {
        return this.monitoredAppName;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "DaemonConfig{apiKey='" + this.apiKey + '\'' + ", metricsUri=" + this.metricsUri + ", eventsUri=" + this.eventsUri + ", jmxHost='" + this.jmxHost + '\'' + ", jmxPort=" + this.jmxPort + ", useSharedFilesystem=" + this.useSharedFilesystem + ", useLicenseKey=" + this.useLicenseKey + ", harvestInterval=" + this.harvestInterval.getSeconds() + ", queueSize=" + this.queueSize + ", daemonVersion='" + this.daemonVersion + '\'' + ", monitoredAppName='" + this.monitoredAppName + '\'' + ", proxyHost='" + this.proxyHost + '\'' + ", proxyPort='" + this.proxyPort + '\'' + ", proxyUser='" + this.proxyUser + '\'' + ", proxyPassword='" + this.proxyPassword + '\'' + ", proxyScheme='" + this.proxyScheme + '\'' + ", auditLogging=" + this.auditLogging + '}';
    }

    static /* synthetic */ Duration access$1600() {
        return DEFAULT_HARVEST_DURATION;
    }

    static /* synthetic */ String access$1700() {
        return DEFAULT_PROXY_HOST;
    }

    static /* synthetic */ Integer access$1800() {
        return DEFAULT_PROXY_PORT;
    }

    static /* synthetic */ String access$1900() {
        return DEFAULT_PROXY_USER;
    }

    static /* synthetic */ String access$2000() {
        return DEFAULT_PROXY_PASSWORD;
    }

    static /* synthetic */ String access$2100() {
        return DEFAULT_PROXY_SCHEME;
    }

    public static class Builder {
        private boolean auditLogging = false;
        private boolean useLicenseKey = false;
        private String apiKey;
        private URI metricsUri;
        private URI eventsUri;
        private String jmxHost = "localhost";
        private Integer jmxPort = 1099;
        private boolean useSharedFilesystem = false;
        private Duration harvestInterval = DaemonConfig.access$1600();
        private Integer queueSize = DEFAULT_QUEUE_SIZE;
        public String daemonVersion = "UNKNOWN-VERSION";
        public String monitoredAppName = "My Application";
        private String proxyHost = DaemonConfig.access$1700();
        private Integer proxyPort = DaemonConfig.access$1800();
        private String proxyUser = DaemonConfig.access$1900();
        private String proxyPassword = DaemonConfig.access$2000();
        private String proxyScheme = DaemonConfig.access$2100();
        private String threadNamePattern = "((?<=[\\W_]|^)([0-9a-fA-F]){4,}(?=[\\W_]|$))|\\d+";

        public Builder auditLogging(boolean auditLogging) {
            this.auditLogging = auditLogging;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder metricsUri(URI metricsUri) {
            this.metricsUri = metricsUri;
            return this;
        }

        public Builder eventsUri(URI eventsUri) {
            this.eventsUri = eventsUri;
            return this;
        }

        public Builder jmxHost(String host) {
            this.jmxHost = host;
            return this;
        }

        public Builder jmxPort(int port) {
            this.jmxPort = port;
            return this;
        }

        public Builder useSharedFilesystem(boolean useSharedFilesystem) {
            this.useSharedFilesystem = useSharedFilesystem;
            return this;
        }

        public Builder useLicenseKey(boolean useLicenseKey) {
            this.useLicenseKey = useLicenseKey;
            return this;
        }

        public Builder harvestInterval(Integer interval) {
            if (interval != null) {
                this.harvestInterval = Duration.ofSeconds(interval.intValue());
            }
            return this;
        }

        public Builder queueSize(Integer queueSize) {
            if (queueSize != null) {
                this.queueSize = queueSize;
            }
            return this;
        }

        public Builder daemonVersion(String daemonVersion) {
            this.daemonVersion = daemonVersion;
            return this;
        }

        public Builder monitoredAppName(String monitoredAppName) {
            this.monitoredAppName = monitoredAppName;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder proxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder proxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder proxyScheme(String proxyScheme) {
            this.proxyScheme = proxyScheme;
            return this;
        }

        public Builder threadNamePattern(String threadNamePattern) {
            this.threadNamePattern = threadNamePattern;
            return this;
        }

        public <T> Builder maybeEnv(String envKey, Function<String, T> mapper, Function<T, Builder> builderMethod) {
            String envValue = this.getEnv(envKey);
            if (envValue != null) {
                T value = mapper.apply(envValue);
                return builderMethod.apply(value);
            }
            return this;
        }

        String getEnv(String envKey) {
            return System.getenv(envKey);
        }

        public DaemonConfig build() {
            if (this.apiKey == null) {
                throw new RuntimeException("INSIGHTS_INSERT_KEY environment variable is required!");
            }
            return new DaemonConfig(this);
        }
    }
}

