/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamingUtility;
import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;

class HigherPriorityTransactionNamingPolicy
extends TransactionNamingPolicy {
    HigherPriorityTransactionNamingPolicy() {
    }

    @Override
    public boolean canSetTransactionName(Transaction tx, TransactionNamePriority priority) {
        PriorityTransactionName ptn;
        if (priority == null) {
            return false;
        }
        if (NewRelic.getAgent().getLogger().isLoggable(Level.FINEST)) {
            Agent.LOG.log(Level.FINEST, "agent.transaction.HigherPriorityTransactionNamingPolicy::canSetTransactionName: txn: {0}, txnPriorityTxnName: {1}, txnNamingScheme: {2},  priority: {3}", tx.toString(), tx.getPriorityTransactionName().toString(), tx.getNamingScheme().toString(), priority.toString());
        }
        return TransactionNamingUtility.comparePriority(priority, (ptn = tx.getPriorityTransactionName()).getPriority(), tx.getNamingScheme()) > 0;
    }
}

