/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.logging;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AgentLinkingMetadata;
import com.newrelic.agent.ExtendedTransactionListener;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.TraceMetadataImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.attributes.DisabledExcludeIncludeFilter;
import com.newrelic.agent.attributes.ExcludeIncludeFilter;
import com.newrelic.agent.attributes.ExcludeIncludeFilterImpl;
import com.newrelic.agent.attributes.LogAttributeValidator;
import com.newrelic.agent.bridge.logging.LogAttributeKey;
import com.newrelic.agent.bridge.logging.LogAttributeType;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.ApplicationLoggingConfig;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.model.LogEvent;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.service.logging.LogSenderHarvestableImpl;
import com.newrelic.agent.service.logging.LogSenderService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.agent.util.NoOpQueue;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.Logs;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class LogSenderServiceImpl
extends AbstractService
implements LogSenderService {
    private volatile boolean forwardingEnabled;
    private static boolean logLabelsEnabled;
    private static Map<String, String> labels;
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    private volatile int maxSamplesStored;
    volatile long reportPeriodInMillis = 5000L;
    private final ConcurrentHashMap<String, DistributedSamplingPriorityQueue<LogEvent>> reservoirForApp = new ConcurrentHashMap();
    private static final LoadingCache<String, String> stringCache;
    public static final String METHOD = "add log event attribute";
    public static final String LOG_SENDER_SERVICE = "Log Sender Service";
    private volatile ExcludeIncludeFilter contextDataKeyFilter;
    protected final ExtendedTransactionListener transactionListener = new ExtendedTransactionListener(){

        @Override
        public void dispatcherTransactionStarted(Transaction transaction) {
        }

        @Override
        public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
            TransactionLogs data = (TransactionLogs)transactionData.getLogEventData();
            LogSenderServiceImpl.this.storeEvents(transactionData.getApplicationName(), transactionData.getPriority(), data.events);
        }

        @Override
        public void dispatcherTransactionCancelled(Transaction transaction) {
            TransactionLogs data = (TransactionLogs)transaction.getLogEventData();
            LogSenderServiceImpl.this.storeEvents(transaction.getApplicationName(), transaction.getPriority(), data.events);
        }
    };
    protected final AgentConfigListener configListener = new AgentConfigListener(){

        @Override
        public void configChanged(String appName, AgentConfig agentConfig) {
            ApplicationLoggingConfig appLoggingConfig = agentConfig.getApplicationLoggingConfig();
            LogSenderServiceImpl.this.isEnabledForApp.remove(appName);
            LogSenderServiceImpl.this.maxSamplesStored = (int)((double)appLoggingConfig.getMaxSamplesStored() * ((double)LogSenderServiceImpl.this.reportPeriodInMillis / 60000.0));
            LogSenderServiceImpl.this.forwardingEnabled = appLoggingConfig.isForwardingEnabled();
            LogSenderServiceImpl.this.contextDataKeyFilter = LogSenderServiceImpl.this.createContextDataKeyFilter(appLoggingConfig);
            boolean metricsEnabled = appLoggingConfig.isMetricsEnabled();
            boolean localDecoratingEnabled = appLoggingConfig.isLocalDecoratingEnabled();
            LogSenderServiceImpl.this.recordApplicationLoggingSupportabilityMetrics(LogSenderServiceImpl.this.forwardingEnabled, metricsEnabled, localDecoratingEnabled, logLabelsEnabled);
        }
    };
    private final List<Harvestable> harvestables = new ArrayList<Harvestable>();

    public void recordApplicationLoggingSupportabilityMetrics(boolean forwardingEnabled, boolean metricsEnabled, boolean localDecoratingEnabled, boolean logLabelsEnabled) {
        StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
        if (forwardingEnabled) {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/Forwarding/Java/enabled");
        } else {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/Forwarding/Java/disabled");
        }
        if (metricsEnabled) {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/Metrics/Java/enabled");
        } else {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/Metrics/Java/disabled");
        }
        if (localDecoratingEnabled) {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/LocalDecorating/Java/enabled");
        } else {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/LocalDecorating/Java/disabled");
        }
        if (logLabelsEnabled) {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/Labels/Java/enabled");
        } else {
            statsService.getMetricAggregator().incrementCounter("Supportability/Logging/Labels/Java/disabled");
        }
    }

    public LogSenderServiceImpl() {
        super(LogSenderServiceImpl.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        ApplicationLoggingConfig appLoggingConfig = config.getApplicationLoggingConfig();
        this.maxSamplesStored = (int)((double)appLoggingConfig.getMaxSamplesStored() * ((double)this.reportPeriodInMillis / 60000.0));
        this.forwardingEnabled = appLoggingConfig.isForwardingEnabled();
        this.contextDataKeyFilter = this.createContextDataKeyFilter(appLoggingConfig);
        logLabelsEnabled = appLoggingConfig.isLogLabelsEnabled();
        labels = appLoggingConfig.removeExcludedLogLabels(config.getLabelsConfig().getLabels());
        this.isEnabledForApp.put(config.getApplicationName(), this.forwardingEnabled);
    }

    private ExcludeIncludeFilter createContextDataKeyFilter(ApplicationLoggingConfig appLoggingConfig) {
        if (appLoggingConfig.isForwardingContextDataEnabled()) {
            List<String> include = appLoggingConfig.getForwardingContextDataInclude();
            List<String> exclude = appLoggingConfig.getForwardingContextDataExclude();
            return new ExcludeIncludeFilterImpl("application_logging.forwarding.context_data", exclude, include);
        }
        return DisabledExcludeIncludeFilter.INSTANCE;
    }

    @Override
    public boolean isEnabled() {
        return this.forwardingEnabled;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getTransactionService().addTransactionListener(this.transactionListener);
        ServiceFactory.getConfigService().addIAgentConfigListener(this.configListener);
    }

    @Override
    protected void doStop() throws Exception {
        this.removeHarvestables();
        ServiceFactory.getTransactionService().removeTransactionListener(this.transactionListener);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this.configListener);
        this.reservoirForApp.clear();
        this.isEnabledForApp.clear();
        stringCache.invalidateAll();
    }

    private void removeHarvestables() {
        for (Harvestable harvestable : this.harvestables) {
            ServiceFactory.getHarvestService().removeHarvestable(harvestable);
        }
    }

    public void recordLogEvent(Map<LogAttributeKey, ?> attributes) {
        if (this.logEventsDisabled() || attributes == null || attributes.isEmpty()) {
            return;
        }
        Transaction transaction = ServiceFactory.getTransactionService().getTransaction(false);
        if (transaction == null || !transaction.isInProgress() || transaction.isIgnore()) {
            AgentConfig agentConfig;
            String applicationName = ServiceFactory.getRPMService().getApplicationName();
            if (transaction != null && transaction.getApplicationName() != null) {
                applicationName = transaction.getApplicationName();
            }
            if (!this.getIsEnabledForApp(agentConfig = ServiceFactory.getConfigService().getAgentConfig(applicationName), applicationName)) {
                this.reservoirForApp.remove(applicationName);
                return;
            }
            this.createAndStoreEvent(applicationName, attributes);
        } else {
            transaction.getLogEventData().recordLogEvent(attributes);
        }
        MetricNames.recordApiSupportabilityMetric("RecordLogEvent");
    }

    private void storeEvents(String appName, float priority, Collection<LogEvent> events) {
        if (events.size() > 0) {
            DistributedSamplingPriorityQueue<LogEvent> eventList = this.getReservoir(appName);
            for (LogEvent event : events) {
                event.setPriority(priority);
                eventList.add(event);
            }
        }
    }

    @Override
    public void addHarvestableToService(String appName) {
        LogSenderHarvestableImpl harvestable = new LogSenderHarvestableImpl(this, appName);
        ServiceFactory.getHarvestService().addHarvestable(harvestable);
        this.harvestables.add(harvestable);
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    @Override
    public void setMaxSamplesStored(int maxSamplesStored) {
        this.maxSamplesStored = maxSamplesStored;
    }

    @Override
    public void setReportPeriodInMillis(long reportPeriodInMillis) {
        this.reportPeriodInMillis = reportPeriodInMillis;
    }

    @Override
    public void clearReservoir() {
        this.reservoirForApp.clear();
    }

    public void clearReservoir(String appName) {
        DistributedSamplingPriorityQueue<LogEvent> reservoir = this.reservoirForApp.get(appName);
        if (reservoir != null) {
            reservoir.clear();
        }
    }

    @VisibleForTesting
    void configureHarvestables(long reportPeriodInMillis, int maxSamplesStored) {
        for (Harvestable h2 : this.harvestables) {
            h2.configure(reportPeriodInMillis, maxSamplesStored);
        }
    }

    @VisibleForTesting
    public void harvestHarvestables() {
        for (Harvestable h2 : this.harvestables) {
            h2.harvest();
        }
    }

    public void harvestPendingEvents() {
        for (String appName : this.reservoirForApp.keySet()) {
            this.harvestEvents(appName);
        }
    }

    @Override
    public void storeEvent(String appName, LogEvent event) {
        if (this.logEventsDisabled()) {
            return;
        }
        DistributedSamplingPriorityQueue<LogEvent> eventList = this.getReservoir(appName);
        eventList.add(event);
        Agent.LOG.finest(MessageFormat.format("Added Custom Event of type {0}", event.getType()));
    }

    private void createAndStoreEvent(String appName, Map<LogAttributeKey, ?> attributes) {
        if (this.logEventsDisabled()) {
            return;
        }
        DistributedSamplingPriorityQueue<LogEvent> eventList = this.getReservoir(appName);
        eventList.add(LogSenderServiceImpl.createValidatedEvent(attributes, this.contextDataKeyFilter));
        Agent.LOG.finest(MessageFormat.format("Added event of type {0}", "LogEvent"));
    }

    private boolean logEventsDisabled() {
        if (!this.forwardingEnabled) {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected due to high security mode being enabled.", "LogEvent");
            } else {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected. application_logging.forwarding not enabled.", "LogEvent");
            }
            Agent.LOG.log(Level.FINER, "Event of type {0} not collected. application_logging.forwarding not enabled.", "LogEvent");
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public DistributedSamplingPriorityQueue<LogEvent> getReservoir(String appName) {
        DistributedSamplingPriorityQueue<LogEvent> result = this.reservoirForApp.get(appName);
        while (result == null) {
            this.reservoirForApp.putIfAbsent(appName, new DistributedSamplingPriorityQueue(appName, LOG_SENDER_SERVICE, this.maxSamplesStored));
            result = this.reservoirForApp.get(appName);
        }
        return result;
    }

    @Override
    public void harvestEvents(final String appName) {
        if (!this.getIsEnabledForApp(ServiceFactory.getConfigService().getAgentConfig(appName), appName)) {
            this.reservoirForApp.remove(appName);
            return;
        }
        if (this.maxSamplesStored <= 0) {
            this.clearReservoir(appName);
            return;
        }
        long startTimeInNanos = System.nanoTime();
        final DistributedSamplingPriorityQueue reservoir = this.reservoirForApp.put(appName, new DistributedSamplingPriorityQueue(appName, LOG_SENDER_SERVICE, this.maxSamplesStored));
        if (reservoir != null && reservoir.size() > 0) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendLogEvents(Collections.unmodifiableList(reservoir.asList()));
                final long durationInNanos = System.nanoTime() - startTimeInNanos;
                ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                    @Override
                    public void doWork(StatsEngine statsEngine) {
                        LogSenderServiceImpl.this.recordSupportabilityMetrics(statsEngine, durationInNanos, reservoir);
                    }

                    @Override
                    public String getAppName() {
                        return appName;
                    }
                }, LogSenderServiceImpl.class.getName());
                if (reservoir.size() < reservoir.getNumberOfTries()) {
                    int dropped = reservoir.getNumberOfTries() - reservoir.size();
                    Agent.LOG.log(Level.FINE, "Dropped {0} log events out of {1}.", dropped, reservoir.getNumberOfTries());
                }
            }
            catch (HttpError e) {
                if (!e.discardHarvestData()) {
                    Agent.LOG.log(Level.FINE, "Unable to send log events. Unsent events will be included in the next harvest.", e);
                    DistributedSamplingPriorityQueue<LogEvent> currentReservoir = this.reservoirForApp.get(appName);
                    currentReservoir.retryAll(reservoir);
                } else {
                    reservoir.clear();
                    Agent.LOG.log(Level.FINE, "Unable to send log events. Unsent events will be dropped.", e);
                }
            }
            catch (Exception e) {
                reservoir.clear();
                Agent.LOG.log(Level.FINE, "Unable to send log events. Unsent events will be dropped.", e);
            }
        }
    }

    @Override
    public String getEventHarvestIntervalMetric() {
        return "Supportability/EventHarvest/LogEvent/interval";
    }

    @Override
    public String getReportPeriodInSecondsMetric() {
        return "Supportability/EventHarvest/LogEventData/ReportPeriod";
    }

    @Override
    public String getEventHarvestLimitMetric() {
        return "Supportability/EventHarvest/LogEventData/HarvestLimit";
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanoseconds, DistributedSamplingPriorityQueue<LogEvent> reservoir) {
        statsEngine.getStats("Supportability/Logging/Forwarding/Sent").incrementCallCount(reservoir.size());
        statsEngine.getStats("Supportability/Logging/Forwarding/Seen").incrementCallCount(reservoir.getNumberOfTries());
        int droppedLogEvents = reservoir.getNumberOfTries() - reservoir.size();
        if (droppedLogEvents >= 0) {
            statsEngine.getStats("Logging/Forwarding/Dropped").incrementCallCount(droppedLogEvents);
        } else {
            Agent.LOG.log(Level.FINE, "Invalid dropped log events value of {0}. This must be a non-negative value.", droppedLogEvents);
        }
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/LogEvent/transmit").recordResponseTime(durationInNanoseconds, TimeUnit.NANOSECONDS);
    }

    private boolean getIsEnabledForApp(AgentConfig config, String currentAppName) {
        Boolean appEnabled;
        Boolean bl = appEnabled = currentAppName == null ? null : (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = config.getApplicationLoggingConfig().isForwardingEnabled();
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    private static String mapInternString(String value) {
        return stringCache.get(value);
    }

    private static LogEvent createValidatedEvent(Map<LogAttributeKey, ?> attributes, ExcludeIncludeFilter contextDataKeyFilter) {
        Map<String, String> logEventLinkingMetadata = AgentLinkingMetadata.getLogEventLinkingMetadata(TraceMetadataImpl.INSTANCE, ServiceFactory.getConfigService(), ServiceFactory.getRPMService());
        HashMap<String, Object> logEventAttributes = new HashMap<String, Object>(logEventLinkingMetadata);
        if (labels != null && logLabelsEnabled) {
            for (Map.Entry<String, String> label : labels.entrySet()) {
                String labelKey = "tags." + label.getKey();
                logEventAttributes.put(labelKey, label.getValue());
            }
        }
        LogEvent event = new LogEvent(logEventAttributes, DistributedTraceServiceImpl.nextTruncatedFloat());
        LogEventAttributeSender sender = new LogEventAttributeSender(logEventAttributes);
        for (Map.Entry<LogAttributeKey, ?> entry : attributes.entrySet()) {
            LogAttributeKey logAttrKey = entry.getKey();
            Object value = entry.getValue();
            String key = logAttrKey.getKey();
            if (key == null || value == null) {
                Agent.LOG.log(Level.FINEST, "Log event with invalid attributes key or value of null was reported for a transaction but ignored. Each key should be a String and each value should be a String, Number, or Boolean. Key: " + (key == null ? "[null]" : Strings.obfuscate(key)));
                continue;
            }
            if (logAttrKey.type == LogAttributeType.CONTEXT && !contextDataKeyFilter.shouldInclude(logAttrKey.getKey())) continue;
            String prefixedKey = LogSenderServiceImpl.mapInternString(logAttrKey.getPrefixedKey());
            if (value instanceof String) {
                sender.addAttribute(prefixedKey, LogSenderServiceImpl.mapInternString((String)value), METHOD);
                continue;
            }
            if (value instanceof Number) {
                sender.addAttribute(prefixedKey, (Number)value, METHOD);
                continue;
            }
            if (value instanceof Boolean) {
                sender.addAttribute(prefixedKey, (Boolean)value, METHOD);
                continue;
            }
            sender.addAttribute(prefixedKey, LogSenderServiceImpl.mapInternString(value.toString()), METHOD);
        }
        return event;
    }

    @Override
    public Logs getTransactionLogs(AgentConfig config) {
        return new TransactionLogs(config, this.contextDataKeyFilter);
    }

    static {
        stringCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(70L, TimeUnit.SECONDS).executor(Runnable::run).build(key -> key);
    }

    public static final class TransactionLogs
    implements Logs {
        private final Queue<LogEvent> events;
        private final ExcludeIncludeFilter contextDataKeyFilter;

        TransactionLogs(AgentConfig config, ExcludeIncludeFilter contextDataKeyFilter) {
            int maxSamplesStored = config.getApplicationLoggingConfig().getMaxSamplesStored();
            this.events = maxSamplesStored == 0 ? NoOpQueue.getInstance() : new LinkedBlockingQueue(maxSamplesStored);
            this.contextDataKeyFilter = contextDataKeyFilter;
        }

        public void recordLogEvent(Map<LogAttributeKey, ?> attributes) {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected due to high security mode being enabled.", "LogEvent");
                return;
            }
            LogEvent event = LogSenderServiceImpl.createValidatedEvent(attributes, this.contextDataKeyFilter);
            if (this.events.offer(event)) {
                Agent.LOG.log(Level.FINEST, "Added event of type {0} in Transaction.", "LogEvent");
            } else {
                String applicationName = ServiceFactory.getRPMService().getApplicationName();
                ServiceFactory.getServiceManager().getLogSenderService().storeEvent(applicationName, event);
            }
        }

        @VisibleForTesting
        public List<LogEvent> getEventsForTesting() {
            return new ArrayList<LogEvent>(this.events);
        }
    }

    private static class LogEventAttributeSender
    extends AttributeSender {
        private static final String ATTRIBUTE_TYPE = "log";
        private final Map<String, Object> logEventAttributes;

        public LogEventAttributeSender(Map<String, Object> logEventAttributes) {
            super(new LogAttributeValidator(ATTRIBUTE_TYPE));
            this.logEventAttributes = logEventAttributes;
            this.setTransactional(false);
        }

        @Override
        protected String getAttributeType() {
            return ATTRIBUTE_TYPE;
        }

        @Override
        protected Map<String, Object> getAttributeMap() {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isCustomParametersAllowed()) {
                return this.logEventAttributes;
            }
            return null;
        }
    }
}

