/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.tracing;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class NoticeSqlVisitor
extends ClassVisitor {
    private static final Map<String, Type> setterNamesToTypes = ImmutableMap.of("provideConnection", Type.getType(Connection.class), "setRawSql", Type.getType(String.class), "setParams", Type.getType(Object[].class));
    private static final Method noticeSqlMethod = new Method("noticeSql", Type.VOID_TYPE, setterNamesToTypes.values().toArray(new Type[setterNamesToTypes.size()]));
    private final Set<Method> noticeSqlMethods = new HashSet<Method>();

    public NoticeSqlVisitor(int api) {
        super(api);
    }

    @Override
    public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
        return new MethodVisitor(589824){

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (NoticeSqlVisitor.isNoticeSqlMethod(owner, name, desc)) {
                    NoticeSqlVisitor.this.noticeSqlMethods.add(new Method(methodName, methodDesc));
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        };
    }

    public Set<Method> getNoticeSqlMethods() {
        return this.noticeSqlMethods;
    }

    public static boolean isNoticeSqlMethod(String owner, String name, String desc) {
        return owner.equals(BridgeUtils.DATASTORE_METRICS_TYPE.getInternalName()) && name.equals(noticeSqlMethod.getName()) && desc.equals(noticeSqlMethod.getDescriptor());
    }

    public static int getSqlTracerSettersCount() {
        return setterNamesToTypes.size();
    }

    public static Iterator<Map.Entry<String, Type>> getSqlTracerSettersInReverseOrder() {
        LinkedList<Map.Entry<String, Type>> entries = new LinkedList<Map.Entry<String, Type>>(setterNamesToTypes.entrySet());
        return entries.descendingIterator();
    }
}

