/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.PointCutConfig;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.instrumentation.custom.ExtensionClassAndMethodMatcher;
import com.newrelic.agent.jmx.create.JmxConfiguration;
import com.newrelic.agent.jmx.create.JmxYmlParser;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class YamlExtension
extends Extension {
    private final Config configuration;
    private final boolean enabled;

    public YamlExtension(ClassLoader classloader, String name, Map<String, Object> configuration, boolean custom) throws IllegalArgumentException {
        super(classloader, name, custom);
        if (name == null) {
            throw new IllegalArgumentException("Extensions must have a name");
        }
        this.configuration = new BaseConfig(configuration);
        this.enabled = this.configuration.getProperty("enabled", true);
    }

    YamlExtension(ClassLoader classloader, Map<String, Object> config, boolean custom) {
        this(classloader, (String)config.get("name"), config, custom);
    }

    @Override
    public String toString() {
        return this.getName() + " Extension";
    }

    public final Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getVersion() {
        return this.configuration.getProperty("version", "n/a");
    }

    @Override
    public double getVersionNumber() {
        try {
            return this.configuration.getProperty("version", 0.0);
        }
        catch (Exception e) {
            Agent.LOG.severe(MessageFormat.format("Extension \"{0}\" has an invalid version number: {1}: {2}", this.getName(), e.getClass().getSimpleName(), e.getMessage()));
            return 0.0;
        }
    }

    @Override
    public Collection<JmxConfiguration> getJmxConfig() {
        Object jmx = this.getConfiguration().getProperty("jmx");
        if (jmx != null && jmx instanceof List) {
            ArrayList<JmxConfiguration> list = new ArrayList<JmxConfiguration>();
            for (Map config : (List)jmx) {
                list.add(new JmxYmlParser(config));
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ExtensionClassAndMethodMatcher> getInstrumentationMatchers() {
        if (this.isEnabled()) {
            Object instrumentation = this.getConfiguration().getProperty("instrumentation");
            if (instrumentation instanceof Map) {
                return PointCutConfig.getExtensionPointCuts(this, (Map)instrumentation);
            }
            if (this.configuration.getProperty("jmx", null) == null) {
                String msg = MessageFormat.format("Extension {0} either does not have an instrumentation section or has an invalid instrumentation section. Please check the format of the file.", this.getName());
                Agent.LOG.severe(msg);
            }
        }
        return Collections.emptyList();
    }
}

