/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.agentcontrol;

import com.newrelic.agent.agentcontrol.AgentControlIntegrationClientFactory;
import com.newrelic.agent.agentcontrol.AgentControlIntegrationHealthClient;
import com.newrelic.agent.agentcontrol.AgentHealth;
import com.newrelic.agent.agentcontrol.HealthDataChangeListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentControlIntegrationConfig;
import java.util.List;

public class AgentControlIntegrationUtils {
    public static long getPseudoCurrentTimeNanos() {
        return System.currentTimeMillis() * 1000000L;
    }

    public static void reportUnhealthyStatus(List<HealthDataChangeListener> healthDataChangeListeners, AgentHealth.Status newStatus, String ... additionalInfo) {
        for (HealthDataChangeListener listener : healthDataChangeListeners) {
            listener.onUnhealthyStatus(newStatus, additionalInfo);
        }
    }

    public static void reportHealthyStatus(List<HealthDataChangeListener> healthDataChangeListeners, AgentHealth.Category ... categories) {
        for (HealthDataChangeListener listener : healthDataChangeListeners) {
            listener.onHealthyStatus(categories);
        }
    }

    public static void reportUnhealthyStatusPriorToServiceStart(AgentConfig config, AgentHealth.Status status) {
        AgentControlIntegrationConfig agentControlIntegrationConfig = config.getAgentControlIntegrationConfig();
        if (agentControlIntegrationConfig.isEnabled()) {
            AgentControlIntegrationHealthClient client = AgentControlIntegrationClientFactory.createHealthClient(agentControlIntegrationConfig);
            AgentHealth agentHealth = new AgentHealth(AgentControlIntegrationUtils.getPseudoCurrentTimeNanos());
            agentHealth.setUnhealthyStatus(status, new String[0]);
            client.sendHealthMessage(agentHealth);
        }
    }
}

