/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnList;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.weave.utils.WeaveUtils;
import java.util.Collection;

class GeneratedNewFieldMethod {
    public final Method method;
    public final String newFieldName;
    public final String newFieldDesc;
    public final int opcode;
    public final boolean returnsPutValue;

    private GeneratedNewFieldMethod(Method method, String newFieldName, String newFieldDesc, int opcode) {
        this.method = method;
        this.newFieldName = newFieldName;
        this.newFieldDesc = newFieldDesc;
        this.opcode = opcode;
        this.returnsPutValue = (opcode == 181 || opcode == 179) && method.getReturnType() != Type.VOID_TYPE;
    }

    public static GeneratedNewFieldMethod isGeneratedNewFieldMethod(MethodNode method, Collection<String> newFields) {
        if ((method.access & 0x1000) == 0 || !WeaveUtils.isSyntheticAccessor(method.name)) {
            return null;
        }
        InsnList instructions = method.instructions;
        for (int i = 1; i < instructions.size() - 1; ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getType() == 4) {
                String fieldName = ((FieldInsnNode)instruction).name;
                if (!newFields.contains(fieldName)) {
                    return null;
                }
                int nextInsnOpcode = instructions.get(i + 1).getOpcode();
                return new GeneratedNewFieldMethod(new Method(method.name, method.desc), fieldName, ((FieldInsnNode)instruction).desc, instruction.getOpcode());
            }
            if (instruction.getType() != 5) continue;
            return null;
        }
        return null;
    }
}

