/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.CacheLoader;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.bootstrap.EmbeddedJarFiles;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class EmbeddedJarFilesImpl
implements EmbeddedJarFiles {
    private static final String[] INTERNAL_JAR_FILE_NAMES = new String[]{"agent-bridge", "newrelic-api", "newrelic-weaver-api", "newrelic-security-agent"};
    public static final EmbeddedJarFiles INSTANCE = new EmbeddedJarFilesImpl();
    private static final String TEMP_JAR_FILE_AGE_THRESHOLD_ENV_CONFIG = "NEW_RELIC_TEMP_JARFILE_AGE_THRESHOLD_HOURS";
    private static final String TEMP_JAR_FILE_AGE_THRESHOLD_SYSPROP_CONFIG = "newrelic.config.temp_jarfile_age_threshold_hours";
    private static final String JAVA_IO_TMP_DIR = "java.io.tmpdir";
    private final LoadingCache<String, File> embeddedAgentJarFiles = Caffeine.newBuilder().executor(Runnable::run).build(new CacheLoader<String, File>(){

        @Override
        public File load(String jarNameWithoutExtension) throws IOException {
            InputStream jarStream = EmbeddedJarFilesImpl.class.getClassLoader().getResourceAsStream(jarNameWithoutExtension + ".jar");
            if (jarStream == null) {
                throw new FileNotFoundException(jarNameWithoutExtension + ".jar");
            }
            File file = File.createTempFile(jarNameWithoutExtension, ".jar", BootstrapLoader.getTempDir());
            file.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(file);){
                BootstrapLoader.copy(jarStream, out, 8096, true);
                File file2 = file;
                return file2;
            }
        }
    });
    private final String[] jarFileNames;

    public static void cleanupStaleTempJarFiles() {
        int thresholdInHours = EmbeddedJarFilesImpl.getStaleTempJarFileAgeConfig();
        if (thresholdInHours > 0) {
            IAgentLogger logger = AgentLogManager.getLogger();
            ArrayList<String> internalJarNamePrefixes = new ArrayList<String>(Arrays.asList(INTERNAL_JAR_FILE_NAMES));
            internalJarNamePrefixes.addAll(Arrays.asList("instrumentation", "newrelic-bootstrap", "newrelic-security-api", "agent-bridge-datastore"));
            File tmpDir = BootstrapLoader.getTempDir();
            if (tmpDir == null) {
                tmpDir = new File(System.getProperty(JAVA_IO_TMP_DIR));
            }
            if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                return;
            }
            long cutoffTime = System.currentTimeMillis() - (long)thresholdInHours * 60L * 60L * 1000L;
            File[] files = tmpDir.listFiles((dir, name) -> {
                if (!name.endsWith(".jar")) {
                    return false;
                }
                for (String jarName : internalJarNamePrefixes) {
                    if (!name.startsWith(jarName)) continue;
                    return true;
                }
                return false;
            });
            if (files == null) {
                return;
            }
            logger.info("New Relic Agent: Removing stale temporary agent file jars from " + tmpDir.getAbsoluteFile() + " older than " + thresholdInHours + " hour(s)");
            int deletedCount = 0;
            long totalBytes = 0L;
            for (File file : files) {
                if (!file.isFile() || file.lastModified() >= cutoffTime) continue;
                try {
                    long fileSize = file.length();
                    if (!file.delete()) continue;
                    ++deletedCount;
                    totalBytes += fileSize;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            logger.info("New Relic Agent: Deleted " + deletedCount + " stale temporary jar files freeing up " + totalBytes + " bytes");
        }
    }

    private static int getStaleTempJarFileAgeConfig() {
        String sysVal = System.getProperty(TEMP_JAR_FILE_AGE_THRESHOLD_SYSPROP_CONFIG);
        String envVal = System.getenv(TEMP_JAR_FILE_AGE_THRESHOLD_ENV_CONFIG);
        int threshold = 0;
        try {
            if (envVal != null) {
                threshold = Integer.parseInt(envVal);
            } else if (sysVal != null) {
                threshold = Integer.parseInt(sysVal);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return threshold;
    }

    public EmbeddedJarFilesImpl() {
        this(INTERNAL_JAR_FILE_NAMES);
    }

    public EmbeddedJarFilesImpl(String[] jarFileNames) {
        this.jarFileNames = jarFileNames;
    }

    @Override
    public File getJarFileInAgent(String jarNameWithoutExtension) throws IOException {
        return this.embeddedAgentJarFiles.get(jarNameWithoutExtension);
    }

    @Override
    public String[] getEmbeddedAgentJarFileNames() {
        return this.jarFileNames;
    }
}

