/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.util.DelegatingInstrumentation;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.logging.Level;

public class InstrumentationWrapper
extends DelegatingInstrumentation {
    public InstrumentationWrapper(Instrumentation delegate) {
        super(delegate);
    }

    @Override
    public void retransformClasses(Class<?> ... classes) throws UnmodifiableClassException {
        if (Agent.LOG.isFinestEnabled()) {
            StringBuilder sb = new StringBuilder("Classes about to be retransformed: ");
            for (Class<?> current : classes) {
                sb.append(current.getName()).append(" ");
            }
            Agent.LOG.log(Level.FINEST, sb.toString());
        }
        super.retransformClasses(classes);
    }

    @Override
    public void redefineClasses(ClassDefinition ... definitions) throws ClassNotFoundException, UnmodifiableClassException {
        if (Agent.LOG.isFinestEnabled()) {
            StringBuilder sb = new StringBuilder("Classes about to be redefined: ");
            for (ClassDefinition current : definitions) {
                sb.append(current.getDefinitionClass().getName()).append(" ");
            }
            Agent.LOG.log(Level.FINEST, sb.toString());
        }
        this.delegate.redefineClasses(definitions);
    }
}

