/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.metrics;

import java.text.MessageFormat;
import java.util.Map;

public enum JmxAction {
    USE_FIRST_ATT{

        @Override
        public float performAction(String[] pAttributes, Map<String, Float> pValues) throws IllegalArgumentException {
            if (pAttributes == null || pAttributes.length == 0) {
                return 0.0f;
            }
            return JmxAction.getValue(pValues, pAttributes[0]);
        }
    }
    ,
    USE_FIRST_RECORDED_ATT{

        @Override
        public float performAction(String[] pAttributes, Map<String, Float> pValues) throws IllegalArgumentException {
            if (pAttributes == null || pAttributes.length == 0) {
                return 0.0f;
            }
            Float value = null;
            for (String current : pAttributes) {
                value = JmxAction.getValueNullOkay(pValues, current);
                if (value == null) continue;
                return value.floatValue();
            }
            return 0.0f;
        }
    }
    ,
    SUBTRACT_ALL_FROM_FIRST{

        @Override
        public float performAction(String[] pAttributes, Map<String, Float> values2) throws IllegalArgumentException {
            float output;
            if (pAttributes == null) {
                output = 0.0f;
            } else {
                int length = pAttributes.length;
                if (length == 0) {
                    output = 0.0f;
                } else {
                    output = JmxAction.getValue(values2, pAttributes[0]);
                    if (length > 1) {
                        for (int i = 1; i < length; ++i) {
                            output -= JmxAction.getValue(values2, pAttributes[i]);
                        }
                    }
                    if (output < 0.0f) {
                        throw new IllegalArgumentException(MessageFormat.format("The output value can not be negative: {0} ", Float.valueOf(output)));
                    }
                }
            }
            return output;
        }
    }
    ,
    SUM_ALL{

        @Override
        public float performAction(String[] pAttributes, Map<String, Float> values2) throws IllegalArgumentException {
            float output;
            if (pAttributes == null) {
                output = 0.0f;
            } else {
                int length = pAttributes.length;
                if (length == 0) {
                    output = 0.0f;
                } else {
                    output = JmxAction.getValue(values2, pAttributes[0]);
                    if (length > 1) {
                        for (int i = 1; i < length; ++i) {
                            output += JmxAction.getValue(values2, pAttributes[i]);
                        }
                    }
                    if (output < 0.0f) {
                        throw new IllegalArgumentException(MessageFormat.format("The output value can not be negative: {0} ", Float.valueOf(output)));
                    }
                }
            }
            return output;
        }
    };


    public abstract float performAction(String[] var1, Map<String, Float> var2) throws IllegalArgumentException;

    private static float getValue(Map<String, Float> values2, String att) {
        Float value = values2.get(att);
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format("There is no value for attribute {0}", att));
        }
        return value.floatValue();
    }

    private static Float getValueNullOkay(Map<String, Float> values2, String att) {
        Float value = values2.get(att);
        if (value == null) {
            return null;
        }
        return value;
    }
}

