/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.agentcontrol;

import com.newrelic.agent.Agent;
import com.newrelic.agent.agentcontrol.AgentControlIntegrationHealthClient;
import com.newrelic.agent.agentcontrol.AgentControlIntegrationUtils;
import com.newrelic.agent.agentcontrol.AgentHealth;
import com.newrelic.agent.agentcontrol.HealthDataChangeListener;
import com.newrelic.agent.agentcontrol.HealthDataProducer;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.api.agent.NewRelic;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class AgentControlIntegrationService
extends AbstractService
implements HealthDataChangeListener {
    private final AgentConfig agentConfig;
    private final AgentControlIntegrationHealthClient client;
    private final AgentHealth agentHealth;
    private ScheduledExecutorService scheduler;

    public AgentControlIntegrationService(AgentControlIntegrationHealthClient client, AgentConfig agentConfig, HealthDataProducer ... healthProducers) {
        super(AgentControlIntegrationService.class.getSimpleName());
        this.agentConfig = agentConfig;
        this.client = client;
        this.agentHealth = new AgentHealth(AgentControlIntegrationUtils.getPseudoCurrentTimeNanos());
        for (HealthDataProducer healthProducer : healthProducers) {
            healthProducer.registerHealthDataChangeListener(this);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isEnabled()) {
            Agent.LOG.log(Level.INFO, "AgentControlIntegrationService starting: Health file location: {0}  Frequency: {1}  Scheme: {2}", this.agentConfig.getAgentControlIntegrationConfig().getHealthDeliveryLocation(), this.agentConfig.getAgentControlIntegrationConfig().getHealthReportingFrequency(), this.agentConfig.getAgentControlIntegrationConfig().getHealthClientType());
            NewRelic.getAgent().getMetricAggregator().incrementCounter("Supportability/AgentControl/Health/enabled");
            int messageSendFrequency = this.agentConfig.getAgentControlIntegrationConfig().getHealthReportingFrequency();
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("New Relic Agent Control Integration Service", true));
            this.scheduler.scheduleWithFixedDelay(() -> this.client.sendHealthMessage(this.agentHealth), messageSendFrequency, messageSendFrequency, TimeUnit.SECONDS);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.isEnabled()) {
            this.scheduler.shutdown();
            this.agentHealth.setUnhealthyStatus(AgentHealth.Status.SHUTDOWN, new String[0]);
            this.client.sendHealthMessage(this.agentHealth);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.agentConfig.getAgentControlIntegrationConfig().isEnabled() && this.client != null && this.client.isValid();
    }

    @Override
    public void onUnhealthyStatus(AgentHealth.Status newStatus, String ... additionalInfo) {
        if (this.isEnabled()) {
            this.agentHealth.setUnhealthyStatus(newStatus, additionalInfo);
        }
    }

    @Override
    public void onHealthyStatus(AgentHealth.Category ... categories) {
        if (this.isEnabled()) {
            for (AgentHealth.Category category : categories) {
                this.agentHealth.setHealthyStatus(category);
            }
        }
    }

    @Override
    public void assignEntityGuid(String entityGuid) {
        if (this.isEnabled()) {
            this.agentHealth.setEntityGuid(entityGuid);
        }
    }
}

