/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.model;

import com.newrelic.agent.model.PriorityAware;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class AnalyticsEvent
implements PriorityAware {
    private static final Pattern TYPE_VALID = Pattern.compile("^[a-zA-Z0-9:_ ]{1,255}$");
    private final float priority;
    private final String type;
    private final long timestamp;
    private final Map<String, ?> userAttributes;

    protected AnalyticsEvent(String type, long timestamp, float priority, Map<String, ?> userAttributes) {
        this.type = type;
        this.timestamp = timestamp;
        this.priority = priority;
        this.userAttributes = userAttributes != null ? userAttributes : new HashMap();
    }

    protected Map<String, ?> getMutableUserAttributes() {
        return this.userAttributes;
    }

    public static boolean isValidType(String type) {
        return type != null && TYPE_VALID.matcher(type).matches();
    }

    public boolean isValid() {
        return AnalyticsEvent.isValidType(this.type);
    }

    public String getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public Map<String, Object> getUserAttributesCopy() {
        if (this.userAttributes == null) {
            return null;
        }
        return new HashMap<String, Object>(this.userAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsEvent that = (AnalyticsEvent)o;
        return Float.compare(that.priority, this.priority) == 0 && this.timestamp == that.timestamp && Objects.equals(this.type, that.type) && Objects.equals(this.userAttributes, that.userAttributes);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.priority), this.type, this.timestamp, this.userAttributes);
    }
}

