/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tometric;

import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.Workarounds;
import com.newrelic.jfr.tometric.EventToMetric;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public class CPUThreadLoadMapper
implements EventToMetric {
    public static final String SIMPLE_CLASS_NAME = CPUThreadLoadMapper.class.getSimpleName();
    public static final String EVENT_NAME = "jdk.ThreadCPULoad";
    public static final String USER = "user";
    public static final String SYSTEM = "system";
    public static final String THREAD_NAME = "thread.name";
    public static final String JFR_THREAD_CPU_LOAD_USER = "jfr.ThreadCPULoad.user";
    public static final String JFR_THREAD_CPU_LOAD_SYSTEM = "jfr.ThreadCPULoad.system";

    @Override
    public List<? extends Metric> apply(RecordedEvent ev) {
        Optional<String> possibleThreadName = Workarounds.getThreadName(ev);
        if (possibleThreadName.isPresent()) {
            String threadName = possibleThreadName.get();
            long timestamp = ev.getStartTime().toEpochMilli();
            Attributes attr = new Attributes().put(THREAD_NAME, threadName);
            double userGaugeValue = 0.0;
            if (RecordedObjectValidators.hasField(ev, USER, SIMPLE_CLASS_NAME)) {
                userGaugeValue = ev.getDouble(USER);
            }
            double systemGaugeValue = 0.0;
            if (RecordedObjectValidators.hasField(ev, SYSTEM, SIMPLE_CLASS_NAME)) {
                systemGaugeValue = ev.getDouble(SYSTEM);
            }
            return Arrays.asList(new Gauge(JFR_THREAD_CPU_LOAD_USER, userGaugeValue, timestamp, attr), new Gauge(JFR_THREAD_CPU_LOAD_SYSTEM, systemGaugeValue, timestamp, attr));
        }
        return Collections.emptyList();
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.of(1L, ChronoUnit.SECONDS));
    }
}

