/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.profiler;

import com.newrelic.jfr.MethodSupport;
import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.ThreadNameNormalizer;
import com.newrelic.jfr.profiler.EventToEventSummary;
import com.newrelic.jfr.profiler.FlameLevel;
import com.newrelic.jfr.profiler.FlamegraphMarshaller;
import com.newrelic.jfr.profiler.FrameFlattener;
import com.newrelic.jfr.profiler.JvmStackTraceEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;

public class ProfileSummarizer
implements EventToEventSummary {
    public static final String EVENT_NAME = "jdk.ExecutionSample";
    public static final String NATIVE_EVENT_NAME = "jdk.NativeMethodSample";
    public static final String SIMPLE_CLASS_NAME = ProfileSummarizer.class.getSimpleName();
    public static final String STATE = "state";
    public static final String THREAD_NAME = "thread.name";
    public static final String SAMPLED_THREAD = "sampledThread";
    public static final String JFR_FLAMELEVEL = "JfrFlameLevel";
    public static final String FLAME_NAME = "flamelevel.name";
    public static final String FLAME_VALUE = "flamelevel.value";
    public static final String FLAME_PARENT_ID = "flamelevel.parentId";
    private final FrameFlattener flattener;
    private final ThreadNameNormalizer nameNormalizer;
    private final String eventName;
    private final Map<String, List<JvmStackTraceEvent>> stackTraceEventPerThread = new HashMap<String, List<JvmStackTraceEvent>>();
    private AtomicLong timestamp = new AtomicLong(Long.MAX_VALUE);

    public Map<String, List<JvmStackTraceEvent>> getStackTraceEventPerThread() {
        return this.stackTraceEventPerThread;
    }

    private ProfileSummarizer(String eventName, FrameFlattener frameFlattener, ThreadNameNormalizer nameNormalizer) {
        this.eventName = eventName;
        this.flattener = frameFlattener;
        this.nameNormalizer = nameNormalizer;
    }

    public static ProfileSummarizer forExecutionSample(ThreadNameNormalizer nameNormalizer) {
        return new ProfileSummarizer(EVENT_NAME, new FrameFlattener(), nameNormalizer);
    }

    public static ProfileSummarizer forNativeMethodSample(ThreadNameNormalizer nameNormalizer) {
        return new ProfileSummarizer(NATIVE_EVENT_NAME, new FrameFlattener(), nameNormalizer);
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void accept(RecordedEvent ev) {
        RecordedStackTrace trace = ev.getStackTrace();
        if (trace == null) {
            return;
        }
        this.timestamp.updateAndGet(current -> Math.min(current, ev.getStartTime().toEpochMilli()));
        String threadName = null;
        if (RecordedObjectValidators.hasField(ev, SAMPLED_THREAD, SIMPLE_CLASS_NAME)) {
            RecordedThread sampledThread = ev.getThread(SAMPLED_THREAD);
            threadName = this.nameNormalizer.getNormalizedThreadName(sampledThread.getJavaName());
        }
        String threadState = null;
        if (RecordedObjectValidators.hasField(ev, STATE, SIMPLE_CLASS_NAME)) {
            threadState = ev.getString(STATE);
        }
        JvmStackTraceEvent event = ProfileSummarizer.stackTraceToStackFrames(threadName, threadState, ev.getStackTrace());
        this.stackTraceEventPerThread.computeIfAbsent(event.getThreadName(), k -> new ArrayList()).add(event);
    }

    @Override
    public Stream<Event> summarize() {
        Stream<Event> eventStream = this.stackTraceEventPerThread.entrySet().stream().map(entry -> this.stackTraceToEvent((String)entry.getKey(), (List)entry.getValue())).flatMap(Collection::stream);
        return eventStream;
    }

    private List<Event> stackTraceToEvent(String threadName, List<JvmStackTraceEvent> stackTraces) {
        FlamegraphMarshaller.StackFrame stackFrame = this.stackTraceToStackFrame(stackTraces);
        List<FlameLevel> flameLevels = this.flattener.flatten(stackFrame);
        return this.flameLevelToEvent(flameLevels, threadName);
    }

    private List<Event> flameLevelToEvent(List<FlameLevel> flameLevels, String threadName) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (FlameLevel flameLevel : flameLevels) {
            Attributes attr = new Attributes();
            attr.put(THREAD_NAME, threadName);
            attr.put(FLAME_NAME, flameLevel.getName());
            attr.put(FLAME_VALUE, flameLevel.getCount());
            attr.put(FLAME_PARENT_ID, flameLevel.getParentId());
            events.add(new Event(JFR_FLAMELEVEL, attr, this.timestamp.longValue()));
        }
        return events;
    }

    private FlamegraphMarshaller.StackFrame stackTraceToStackFrame(List<JvmStackTraceEvent> traces) {
        FlamegraphMarshaller out = new FlamegraphMarshaller();
        for (JvmStackTraceEvent trace : traces) {
            Stack<String> stack = new Stack<String>();
            trace.getFrames().forEach(f -> stack.push(this.getFrameName((JvmStackTraceEvent.JvmStackFrame)f)));
            out.processEvent(stack, this.getValue());
        }
        return out.getStackFrame();
    }

    private Integer getValue() {
        return 1;
    }

    private String getFrameName(JvmStackTraceEvent.JvmStackFrame frame) {
        StringBuilder entryBuilder = new StringBuilder();
        entryBuilder.append(frame.getDesc());
        entryBuilder.append(":");
        entryBuilder.append(frame.getLine());
        return entryBuilder.toString();
    }

    private static JvmStackTraceEvent stackTraceToStackFrames(String name, String state, RecordedStackTrace stackTrace) {
        ArrayList<JvmStackTraceEvent.JvmStackFrame> out = new ArrayList<JvmStackTraceEvent.JvmStackFrame>();
        for (RecordedFrame frame : stackTrace.getFrames()) {
            String desc = MethodSupport.describeMethod(frame.getMethod());
            int line = frame.getLineNumber();
            int bytecodeIndex = frame.getBytecodeIndex();
            out.add(new JvmStackTraceEvent.JvmStackFrame(desc, line, bytecodeIndex));
        }
        return new JvmStackTraceEvent(name, state, out);
    }

    @Override
    public void reset() {
        this.stackTraceEventPerThread.clear();
        this.timestamp.set(Long.MAX_VALUE);
    }
}

