/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.model;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.model.AnalyticsEvent;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

public class CustomInsightsEvent
extends AnalyticsEvent
implements JSONStreamAware {
    private volatile float mutablePriority;

    public CustomInsightsEvent(String type, long timestamp, Map<String, Object> attributes, float priority) {
        super(type, timestamp, priority, attributes);
        this.mutablePriority = priority;
    }

    public void setPriority(float priority) {
        this.mutablePriority = priority;
    }

    @Override
    public float getPriority() {
        return this.mutablePriority;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject intrinsics = new JSONObject();
        intrinsics.put("type", this.getType());
        intrinsics.put("timestamp", this.getTimestamp());
        JSONArray.writeJSONString(Arrays.asList(intrinsics, this.getMutableUserAttributes()), out);
    }
}

