/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Remapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DependencyRemapper
extends Remapper {
    private final Set<String> prefixes;
    private final Map<String, String> oldToNew = new HashMap<String, String>();
    static final String DEPENDENCY_PREFIX = "com/newrelic/agent/deps/";

    public DependencyRemapper(Set<String> prefixes) {
        this.prefixes = DependencyRemapper.fix(prefixes);
    }

    private static Set<String> fix(Set<String> prefixes) {
        HashSet<String> fixed = new HashSet<String>();
        for (String prefix : prefixes) {
            if (prefix.startsWith(DEPENDENCY_PREFIX)) {
                fixed.add(prefix.substring(DEPENDENCY_PREFIX.length()));
                continue;
            }
            fixed.add(prefix);
        }
        return ImmutableSet.copyOf(fixed);
    }

    @Override
    public String map(String typeName) {
        for (String prefix : this.prefixes) {
            if (!typeName.startsWith(prefix)) continue;
            String newType = DEPENDENCY_PREFIX + typeName;
            this.oldToNew.put(typeName, newType);
            return newType;
        }
        return super.map(typeName);
    }

    public Map<String, String> getRemappings() {
        return this.oldToNew;
    }

    Set<String> getPrefixes() {
        return this.prefixes;
    }
}

