/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.crac;

import com.newrelic.agent.deps.org.crac.CheckpointException;
import com.newrelic.agent.deps.org.crac.Context;
import com.newrelic.agent.deps.org.crac.GlobalContextWrapper;
import com.newrelic.agent.deps.org.crac.Resource;
import com.newrelic.agent.deps.org.crac.RestoreException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class Core {
    private static final Context<Resource> globalContextWrapper = new GlobalContextWrapper();
    private static final Compat compat;

    static Compat loadCompat(String packageName) {
        try {
            return new Compat(packageName);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public static Context<Resource> getGlobalContext() {
        return globalContextWrapper;
    }

    public static void checkpointRestore() throws CheckpointException, RestoreException {
        if (compat == null) {
            throw new UnsupportedOperationException();
        }
        compat.checkpointRestore();
    }

    static void register(Resource r) {
        if (compat != null) {
            compat.register(r);
        }
    }

    static {
        Compat candidate = null;
        String propCompatImpl = System.getProperty("com.newrelic.agent.deps.org.crac.Core.Compat");
        if (propCompatImpl != null) {
            candidate = Core.loadCompat(propCompatImpl);
        }
        if (candidate == null) {
            candidate = Core.loadCompat("javax.crac");
        }
        if (candidate == null) {
            candidate = Core.loadCompat("jdk.crac");
        }
        compat = candidate;
    }

    static class Compat {
        protected Class clsResource;
        protected Class clsContext;
        protected Class clsCore;
        protected Class clsCheckpointException;
        protected Class clsRestoreException;
        protected final Method checkpointRestore;
        protected final Method register;
        protected final Object globalContext;
        protected List<Exception> registerExceptions = new ArrayList<Exception>();

        protected Compat(String pkg) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            this.clsResource = Class.forName(pkg + ".Resource");
            this.clsContext = Class.forName(pkg + ".Context");
            this.clsCore = Class.forName(pkg + ".Core");
            this.clsCheckpointException = Class.forName(pkg + ".CheckpointException");
            this.clsRestoreException = Class.forName(pkg + ".RestoreException");
            this.checkpointRestore = this.clsCore.getMethod("checkpointRestore", new Class[0]);
            this.register = this.clsContext.getMethod("register", this.clsResource);
            this.globalContext = this.clsCore.getMethod("getGlobalContext", new Class[0]).invoke(null, new Object[0]);
        }

        public void checkpointRestore() throws CheckpointException, RestoreException {
            if (this.registerExceptions.size() != 0) {
                throw new UnsupportedOperationException();
            }
            try {
                this.checkpointRestore.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ite) {
                if (this.clsCheckpointException.isInstance(ite.getCause())) {
                    CheckpointException checkpointException = new CheckpointException();
                    for (Throwable t2 : ite.getCause().getSuppressed()) {
                        checkpointException.addSuppressed(t2);
                    }
                    throw checkpointException;
                }
                if (this.clsRestoreException.isInstance(ite.getCause())) {
                    RestoreException restoreException = new RestoreException();
                    for (Throwable t3 : ite.getCause().getSuppressed()) {
                        restoreException.addSuppressed(t3);
                    }
                    throw restoreException;
                }
                CheckpointException checkpointException = new CheckpointException();
                checkpointException.addSuppressed(ite);
                throw checkpointException;
            }
        }

        public void register(Resource resource) {
            try {
                ResourceWrapper resourceWrapper = new ResourceWrapper(resource);
                Object proxy = Proxy.newProxyInstance(Compat.class.getClassLoader(), new Class[]{this.clsResource}, (InvocationHandler)resourceWrapper);
                resourceWrapper.setProxy(proxy);
                this.register.invoke(this.globalContext, proxy);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.registerExceptions.add(e);
            }
        }
    }

    static class ResourceWrapper
    extends WeakReference<Resource>
    implements InvocationHandler {
        private static final WeakHashMap<Resource, ResourceWrapper> weakMap = new WeakHashMap();
        private Object proxy;
        private Resource strongRef;

        public void setProxy(Object proxy) {
            this.proxy = proxy;
        }

        public ResourceWrapper(Resource referent) {
            super(referent);
            weakMap.put(referent, this);
            this.strongRef = null;
        }

        @Override
        public Object invoke(Object proxy, Method m4, Object[] args2) throws Throwable {
            String name = m4.getName();
            if ("beforeCheckpoint".equals(name)) {
                this.beforeCheckpoint();
                return null;
            }
            if ("afterRestore".equals(name)) {
                this.afterRestore();
                return null;
            }
            if ("toString".equals(name)) {
                return this.toString();
            }
            try {
                return m4.invoke(this.get(), args2);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private void beforeCheckpoint() throws Exception {
            Resource r;
            this.strongRef = r = (Resource)this.get();
            if (r != null) {
                r.beforeCheckpoint(globalContextWrapper);
            }
        }

        private void afterRestore() throws Exception {
            Resource r = (Resource)this.get();
            this.strongRef = null;
            if (r != null) {
                r.afterRestore(globalContextWrapper);
            }
        }

        public String toString() {
            return "com.newrelic.agent.deps.org.crac.ResourceWrapper[" + ((Resource)this.get()).toString() + "]";
        }
    }
}

