/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.WeakRefTransaction;
import com.newrelic.agent.bridge.NoOpTracedMethod;
import com.newrelic.agent.bridge.TracedActivity;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.AttributeHolder;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.OutboundHeaders;
import com.newrelic.api.agent.Transaction;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class Segment
implements TracedActivity,
AttributeHolder {
    private volatile Tracer underlyingTracer;
    private volatile Tracer parent;
    private volatile WeakRefTransaction weakRefTransaction;
    private final long parentInitialExclusiveDuration;
    private final AtomicBoolean isFinished = new AtomicBoolean(false);
    private final String initiatingThread = Thread.currentThread().getName();
    public static final String UNNAMED_SEGMENT = "Unnamed Segment";
    public static final String START_THREAD = "start_thread";
    public static final String END_THREAD = "end_thread";

    public Segment(Tracer parent, Tracer tracer) {
        this.parent = parent;
        this.underlyingTracer = tracer;
        this.weakRefTransaction = new WeakRefTransaction(parent.getTransactionActivity().getTransaction());
        this.parentInitialExclusiveDuration = parent.getExclusiveDuration();
    }

    public Transaction getTransaction() {
        return this.weakRefTransaction;
    }

    public void ignore() {
        this.ignoreIfUnfinished();
    }

    public void reportAsExternal(ExternalParameters externalParameters) {
        Tracer tracer = this.underlyingTracer;
        if (tracer != null) {
            tracer.reportAsExternal(externalParameters);
        }
    }

    public void setMetricName(String ... metricNameParts) {
        Tracer tracer = this.underlyingTracer;
        if (tracer != null) {
            tracer.setMetricName(metricNameParts);
        }
    }

    public void addOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        Tracer tracer = this.underlyingTracer;
        if (tracer != null) {
            tracer.addOutboundRequestHeaders(outboundHeaders);
        }
    }

    public TracedMethod getTracedMethod() {
        if (this.underlyingTracer == null) {
            return NoOpTracedMethod.INSTANCE;
        }
        return this.underlyingTracer;
    }

    public void setAsyncThreadName(String threadName) {
    }

    public Tracer getParent() {
        return this.parent;
    }

    public Tracer getTracer() {
        return this.underlyingTracer;
    }

    public long getParentInitialExclusiveDuration() {
        return this.parentInitialExclusiveDuration;
    }

    public boolean isFinished() {
        return this.isFinished.get();
    }

    public void ignoreIfUnfinished() {
        if (!this.isFinished.getAndSet(true)) {
            Tracer tracer = this.parent;
            if (tracer != null) {
                tracer.getTransactionActivity().getTransaction().ignoreSegmentIfUnfinished(this);
            }
            this.underlyingTracer = null;
            this.parent = null;
            this.weakRefTransaction = null;
        }
    }

    public void finish() {
        this.finish(null, false);
    }

    public void end() {
        this.finish(null, false);
    }

    public void endAsync() {
        this.finish(null, true);
    }

    public void addCustomAttribute(String key, Number value) {
        if (this.underlyingTracer != null) {
            this.underlyingTracer.addCustomAttribute(key, value);
        }
    }

    public void addCustomAttribute(String key, String value) {
        if (this.underlyingTracer != null) {
            this.underlyingTracer.addCustomAttribute(key, value);
        }
    }

    public void addCustomAttribute(String key, boolean value) {
        if (this.underlyingTracer != null) {
            this.underlyingTracer.addCustomAttribute(key, value);
        }
    }

    public void addCustomAttributes(Map<String, Object> attributes) {
        if (this.underlyingTracer != null) {
            this.underlyingTracer.addCustomAttributes(attributes);
        }
    }

    public void finish(Throwable t2) {
        this.finish(t2, false);
    }

    private void finish(final Throwable t2, boolean async) {
        if (!this.isFinished.getAndSet(true)) {
            this.markFinishTime();
            final Tracer tracer = this.parent;
            final Segment segment = this;
            final String endThreadName = Thread.currentThread().getName();
            if (tracer != null) {
                Runnable expireSegmentRunnable = new Runnable(){

                    @Override
                    public void run() {
                        tracer.getTransactionActivity().getTransaction().finishSegment(segment, t2, Segment.this.parent, endThreadName);
                        Segment.this.underlyingTracer = null;
                        Segment.this.parent = null;
                        Segment.this.weakRefTransaction = null;
                    }
                };
                if (async) {
                    ServiceFactory.getExpirationService().expireSegment(expireSegmentRunnable);
                } else {
                    ServiceFactory.getExpirationService().expireSegmentInline(expireSegmentRunnable);
                }
            }
        }
    }

    public String getInitiatingThread() {
        return this.initiatingThread;
    }

    public void setTruncated() {
        Tracer tracer = this.underlyingTracer;
        if (tracer != null) {
            tracer.setMetricNameFormatInfo(tracer.getMetricName(), "Truncated/" + tracer.getMetricName(), tracer.getTransactionSegmentUri());
        }
    }

    private void markFinishTime() {
        Tracer underlyingTracer = this.underlyingTracer;
        if (underlyingTracer != null) {
            underlyingTracer.markFinishTime();
        }
    }
}

