/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.toevent.AttributeValueSplitter;
import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.util.Collections;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;

public class JVMSystemPropertyMapper
implements EventToEvent {
    public static final String SIMPLE_CLASS_NAME = JVMSystemPropertyMapper.class.getSimpleName();
    public static final String EVENT_NAME = "jdk.InitialSystemProperty";
    public static final String JVM_PROPERTY = "jvmProperty";
    public static final String KEY = "key";
    public static final String JVM_PROPERTY_VALUE = "jvmPropertyValue";
    public static final String VALUE = "value";
    public static final String JFR_JVM_INFORMATION = "JfrJVMInformation";
    private final AttributeValueSplitter valueSplitter;

    public JVMSystemPropertyMapper(AttributeValueSplitter valueSplitter) {
        this.valueSplitter = valueSplitter;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public List<Event> apply(RecordedEvent event) {
        long timestamp = event.getStartTime().toEpochMilli();
        Attributes attr = new Attributes();
        if (RecordedObjectValidators.hasField(event, KEY, SIMPLE_CLASS_NAME)) {
            attr.put(JVM_PROPERTY, event.getString(KEY));
        }
        if (RecordedObjectValidators.hasField(event, VALUE, SIMPLE_CLASS_NAME)) {
            attr.put(JVM_PROPERTY_VALUE, "obfuscated");
        }
        return Collections.singletonList(new Event(JFR_JVM_INFORMATION, attr, timestamp));
    }
}

