/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.tracing;

import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.instrumentation.tracing.DelegatingTraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Annotation
extends AnnotationVisitor {
    private Map<String, Object> values;
    private final TraceDetailsBuilder traceDetailsBuilder;

    public Annotation(AnnotationVisitor annotationVisitor, String desc, TraceDetailsBuilder traceDetailsBuilder) {
        super(589824, annotationVisitor);
        this.traceDetailsBuilder = traceDetailsBuilder;
    }

    public Map<String, Object> getValues() {
        return this.values == null ? Collections.emptyMap() : this.values;
    }

    @Override
    public void visit(String name, Object value) {
        this.getOrCreateValues().put(name, value);
        super.visit(name, value);
    }

    private Map<String, Object> getOrCreateValues() {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        return this.values;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        ArrayList list = (ArrayList)this.getOrCreateValues().get(name);
        if (list == null) {
            list = new ArrayList();
            this.getOrCreateValues().put(name, list);
        }
        final ArrayList theList = list;
        AnnotationVisitor av = super.visitArray(name);
        av = new AnnotationVisitor(589824, av){

            @Override
            public void visit(String name, Object value) {
                super.visit(name, value);
                theList.add(value);
            }
        };
        return av;
    }

    private boolean getBoolean(String name) {
        Boolean value = (Boolean)this.getValues().get(name);
        return value != null && value != false;
    }

    public TraceDetails getTraceDetails(boolean custom) {
        List rollupMetricNames;
        String metricName = (String)this.getValues().get("metricName");
        boolean dispatcher = this.getBoolean("dispatcher");
        if (dispatcher && metricName != null) {
            this.traceDetailsBuilder.setTransactionName(TransactionNamePriority.CUSTOM_HIGH, false, "Custom", metricName);
        }
        if ((rollupMetricNames = (List)this.getValues().get("rollupMetricName")) != null) {
            for (Object v : rollupMetricNames) {
                this.traceDetailsBuilder.addRollupMetricName(v.toString());
            }
        }
        return new DelegatingTraceDetails(this.traceDetailsBuilder.setMetricName(metricName).setDispatcher(dispatcher).setTracerFactoryName((String)this.getValues().get("tracerFactoryName")).setExcludeFromTransactionTrace(this.getBoolean("skipTransactionTrace")).setNameTransaction(this.getBoolean("nameTransaction")).setCustom(custom).setExcludeFromTransactionTrace(this.getBoolean("excludeFromTransactionTrace")).setLeaf(this.getBoolean("leaf")).setAsync(this.getBoolean("async")).build()){

            @Override
            public String getFullMetricName(String className, String methodName) {
                return this.metricName();
            }
        };
    }
}

