/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.transaction.TransactionThrowable;

public interface ErrorAnalyzer {
    public static final int NO_STATUS = 0;
    public static final ErrorAnalyzer DEFAULT = new ErrorAnalyzer(){

        @Override
        public boolean areErrorsEnabled() {
            return true;
        }

        @Override
        public boolean isReportable(int statusCode) {
            return statusCode >= 400;
        }

        @Override
        public boolean isReportable(int statusCode, Throwable throwable) {
            return this.isReportable(statusCode) || throwable != null;
        }

        @Override
        public boolean isReportable(int statusCode, TransactionThrowable transactionThrowable) {
            return this.isReportable(statusCode) || transactionThrowable != null;
        }

        @Override
        public boolean isIgnoredStatus(int statusCode) {
            return false;
        }

        @Override
        public boolean isIgnoredThrowable(Throwable throwable) {
            return false;
        }

        @Override
        public boolean isIgnoredError(int statusCode, Throwable throwable) {
            return false;
        }

        @Override
        public boolean isExpectedError(int statusCode, TransactionThrowable transactionThrowable) {
            return transactionThrowable != null && transactionThrowable.expected;
        }
    };

    public boolean areErrorsEnabled();

    public boolean isReportable(int var1);

    public boolean isReportable(int var1, Throwable var2);

    public boolean isReportable(int var1, TransactionThrowable var2);

    public boolean isIgnoredStatus(int var1);

    public boolean isIgnoredThrowable(Throwable var1);

    public boolean isIgnoredError(int var1, Throwable var2);

    public boolean isExpectedError(int var1, TransactionThrowable var2);
}

