/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc;

import com.newrelic.agent.deps.io.grpc.Configurator;
import com.newrelic.agent.deps.io.grpc.ConfiguratorRegistry;
import com.newrelic.agent.deps.io.grpc.Internal;
import com.newrelic.agent.deps.io.grpc.InternalConfigurator;
import com.newrelic.agent.deps.io.grpc.ManagedChannelBuilder;
import com.newrelic.agent.deps.io.grpc.ServerBuilder;
import java.util.List;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }
}

