/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.database.StatementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SelectVariableStatementFactory
implements StatementFactory {
    private static final Pattern FROM_MATCHER = Pattern.compile("\\s+from\\s+", 34);
    private final ParsedDatabaseStatement innerSelectStatement = new ParsedDatabaseStatement("INNER_SELECT", "select", false);
    private final ParsedDatabaseStatement statement = new ParsedDatabaseStatement("VARIABLE", "select", false);
    private final Pattern pattern = Pattern.compile(".*select\\s+([^\\s,]*).*", 34);

    SelectVariableStatementFactory() {
    }

    @Override
    public ParsedDatabaseStatement parseStatement(String statement) {
        Matcher matcher = this.pattern.matcher(statement);
        if (matcher.matches()) {
            if (FROM_MATCHER.matcher(statement).find()) {
                return this.innerSelectStatement;
            }
            return this.statement;
        }
        return null;
    }

    @Override
    public String getOperation() {
        return "select";
    }
}

