/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import java.util.Map;
import java.util.logging.Level;

public class UtilizationDataConfig
extends BaseConfig {
    public static final String PROPERTY_NAME = "utilization";
    public static final String PROPERTY_ROOT = "newrelic.config.utilization.";
    private static final String LOGICAL_PROC_ENV_KEY = "NEW_RELIC_UTILIZATION_LOGICAL_PROCESSORS";
    private static final String LOGICAL_PROCESSORS = "logical_processors";
    private static final String TOTAL_RAM_ENV_KEY = "NEW_RELIC_UTILIZATION_TOTAL_RAM_MIB";
    private static final String TOTAL_RAM_MIB = "total_ram_mib";
    private static final String HOSTNAME_ENV_KEY = "NEW_RELIC_UTILIZATION_BILLING_HOSTNAME";
    private static final String BILLING_HOSTNAME = "billing_hostname";
    private Long totalRamMibConfig;
    private Integer logicalProcessorsConfig;
    private String billingHostname;

    private String parseConfigVal(String key) {
        if (this.getProperty(key) != null) {
            return this.getProperty(key).toString();
        }
        return null;
    }

    public UtilizationDataConfig(Map<String, Object> props) throws NumberFormatException {
        super(props, PROPERTY_ROOT);
        try {
            this.totalRamMibConfig = this.parseConfigVal(TOTAL_RAM_MIB) == null ? null : new Long(this.parseConfigVal(TOTAL_RAM_MIB));
        }
        catch (NumberFormatException e) {
            Agent.LOG.log(Level.WARNING, "Number expected total_ram_mib configuration {0}", e);
        }
        try {
            this.logicalProcessorsConfig = this.parseConfigVal(LOGICAL_PROCESSORS) == null ? null : new Integer(this.parseConfigVal(LOGICAL_PROCESSORS));
        }
        catch (NumberFormatException e) {
            Agent.LOG.log(Level.WARNING, "Number expected for logical_processors configuration {0}", e);
        }
        this.billingHostname = (String)this.getProperty(BILLING_HOSTNAME);
    }

    @Override
    protected String getSystemPropertyKey(String key) {
        return key;
    }

    public Long getTotalRamMibConfig() {
        Object envVal = this.getPropertyFromSystemEnvironment(TOTAL_RAM_ENV_KEY, null);
        if (envVal != null) {
            try {
                return Long.parseLong(String.valueOf(envVal));
            }
            catch (NumberFormatException nfe) {
                Agent.LOG.log(Level.WARNING, "Sys prop {0}={1} is not a valid number", TOTAL_RAM_ENV_KEY, envVal);
            }
        }
        return this.totalRamMibConfig;
    }

    public Integer getLogicalProcessorsConfig() {
        Object envVal = this.getPropertyFromSystemEnvironment(LOGICAL_PROC_ENV_KEY, null);
        if (envVal != null) {
            try {
                return Integer.parseInt(String.valueOf(envVal));
            }
            catch (NumberFormatException nfe) {
                Agent.LOG.log(Level.WARNING, "Sys prop {0}={1} is not a valid number", LOGICAL_PROC_ENV_KEY, envVal);
            }
        }
        return this.logicalProcessorsConfig;
    }

    public String getBillingHostname() {
        Object envVal = this.getPropertyFromSystemEnvironment(HOSTNAME_ENV_KEY, null);
        if (envVal != null) {
            return String.valueOf(envVal);
        }
        return this.billingHostname;
    }
}

