/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.yaml.snakeyaml.Yaml;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.instrumentation.custom.ExtensionClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.yaml.InstrumentationConstructor;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class PointCutConfig {
    private static String defaultMetricPrefix;
    private Yaml yaml;
    private final List<ExtensionClassAndMethodMatcher> pcList = new ArrayList<ExtensionClassAndMethodMatcher>();

    public static Collection<ExtensionClassAndMethodMatcher> getExtensionPointCuts(Extension extension, Map instrumentation) {
        ArrayList<ExtensionClassAndMethodMatcher> list = new ArrayList<ExtensionClassAndMethodMatcher>();
        if (instrumentation != null) {
            list.addAll(PointCutConfig.addInstrumentation(extension, instrumentation));
        }
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            for (ExtensionClassAndMethodMatcher pc : list.toArray(new ExtensionClassAndMethodMatcher[0])) {
                String msg = MessageFormat.format("Extension instrumentation point: {0} {1}", pc.getClassMatcher(), pc.getMethodMatcher());
                Agent.LOG.finest(msg);
            }
        }
        return list;
    }

    private static Collection<ExtensionClassAndMethodMatcher> addInstrumentation(Extension ext, Map instrumentation) {
        try {
            Map instrumentationMap = instrumentation;
            defaultMetricPrefix = (String)instrumentationMap.get("metric_prefix");
            defaultMetricPrefix = defaultMetricPrefix == null ? "Custom" : defaultMetricPrefix;
            Object pcConfig = instrumentationMap.get("pointcuts");
            PointCutFactory pcFactory = new PointCutFactory(AgentBridge.getAgent().getClass().getClassLoader(), defaultMetricPrefix, ext.getName());
            return pcFactory.getPointCuts(pcConfig);
        }
        catch (Throwable t2) {
            String msg = MessageFormat.format("An error occurred reading the pointcuts in extension {0} : {1}", ext.getName(), t2.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINER, msg, t2);
            return Collections.emptyList();
        }
    }

    public PointCutConfig(File[] files) {
        if (null != files) {
            this.initYaml();
            for (File file : files) {
                try {
                    FileInputStream input = new FileInputStream(file);
                    this.loadYaml(input);
                    Agent.LOG.info(MessageFormat.format("Loaded custom instrumentation from {0}", file.getName()));
                }
                catch (FileNotFoundException e) {
                    Agent.LOG.warning(MessageFormat.format("Could not open instrumentation file {0}. Please check that the file exists and has the correct permissions. ", file.getPath()));
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.SEVERE, MessageFormat.format("Error loading YAML instrumentation from {0}. Please check the file's format.", file.getName()));
                    Agent.LOG.log(Level.FINER, "YAML error: ", e);
                }
            }
        }
    }

    public PointCutConfig(InputStream input) {
        this.initYaml();
        try {
            this.loadYaml(input);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, "Error loading YAML instrumentation");
            Agent.LOG.log(Level.FINER, "Error: ", e);
        }
    }

    private void initYaml() {
        InstrumentationConstructor constructor = new InstrumentationConstructor();
        this.yaml = new Yaml(constructor);
    }

    private void loadYaml(InputStream input) throws ParseException {
        if (null == input) {
            return;
        }
        Object config = this.yaml.load(input);
        PointCutFactory pcFactory = new PointCutFactory(AgentBridge.getAgent().getClass().getClassLoader(), "Custom", "CustomYaml");
        this.pcList.addAll(pcFactory.getPointCuts(config));
    }

    public List<ExtensionClassAndMethodMatcher> getPointCuts() {
        return this.pcList;
    }
}

